#include <assert.h>
#include <stdio.h>
#include <usb.h>
#include <kazzo_request.h>
#include "opendevice.h"
#include "usbconfig.h"

static usb_dev_handle *open(void)
{
	usb_dev_handle *handle = NULL;
	const unsigned char rawVid[2] = {USB_CFG_VENDOR_ID};
	const unsigned char rawPid[2] = {USB_CFG_DEVICE_ID};
	char vendor[] = {USB_CFG_VENDOR_NAME, 0};
	char product[] = {USB_CFG_DEVICE_NAME, 0};
	int vid, pid;

	/* compute VID/PID from usbconfig.h so that there is a central source of information */
	vid = (rawVid[1] << 8) | rawVid[0];
	pid = (rawPid[1] << 8) | rawPid[0];

	if(usbOpenDevice(&handle, vid, vendor, pid, product, NULL, NULL, NULL) == 0){
		return handle;
	}
	fprintf(stderr, "Could not find USB device \"%s\" with vid=0x%x pid=0x%x\n", product, vid, pid);
	return NULL;
}

static void echo(usb_dev_handle *handle)
{
	char buffer[4];
	int i, cnt;
	srand(4649);
	for(i = 0; i < 15000; i++){
		int value = rand() & 0xffff, index = rand() & 0xffff;
		int rxValue, rxIndex;
		if((i+1) % 100 == 0){
			fprintf(stderr, "\r%05d", i+1);
			fflush(stderr);
		}
		cnt = usb_control_msg(
			handle, 
			USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN, 
			REQUEST_ECHO, value, 
			index, buffer, sizeof(buffer), 4000
		);
		if(cnt < 0){
			fprintf(stderr, "\nUSB error in iteration %d: %s\n", i, usb_strerror());
			break;
		}else if(cnt != 4){
			fprintf(stderr, "\nerror in iteration %d: %d bytes received instead of 4\n", i, cnt);
			break;
		}
		rxValue = ((int)buffer[0] & 0xff) | (((int)buffer[1] & 0xff) << 8);
		rxIndex = ((int)buffer[2] & 0xff) | (((int)buffer[3] & 0xff) << 8);
		if(rxValue != value || rxIndex != index){
			fprintf(stderr, "\ndata error in iteration %d:\n", i);
			fprintf(stderr, "rxValue = 0x%04x value = 0x%04x\n", rxValue, value);
			fprintf(stderr, "rxIndex = 0x%04x index = 0x%04x\n", rxIndex, index);
		}
	}
	printf("\nTest completed.\n");
}

int main(int argc, char **argv)
{
	usb_init();
	usb_dev_handle *handle = open();
	
	if(handle != NULL){
		echo(handle);
		usb_close(handle);
		fflush(stdout);
		system("pause");
	}
	return 0;
}
