<?php

/*	umineko
	Japanese verb stemmer
*/

include "functions.php";

mb_http_output("SJIS");
ob_start("mb_output_handler");
$edict = file_get_contents("edict");
$rf = file_get_contents("rules");
$rules = load_rules($rf);
$state = new verb;
$_unchanged = false;

echo "\numineko, japanese verb stemmer\n";
echo "Please enter the verb: "; ob_flush();

$verb = (unicode) mb_convert_encoding(trim(fgets(STDIN)), "UTF-8", "SJIS"); 

if (strlen($verb) == 0) die("Error: Received no input\n");

echo "Deinflecting $verb\n\n"; ob_flush();

$d = deinflect($verb);

echo "Verb $d is $state\n";
echo "Edict: " . find_edict ($d) . "\n";

function deinflect ($verb) {
	global $rules;
	$_verb = $verb;
	$changed = false;
	foreach ($rules as $regex => $code) {
		if (preg_match($regex, $verb, $_)) {
			$env = array("word" => $_[0]);
			if (isset($_[1])) $env["tail"] = $_[1];
			$pre = "global \$state, \$_default_regex; "; foreach ($env as $name => $value) { $pre .= "\$$name = $value; "; }
			$verb = eval($pre . $code);
			unset ($tail); // it's getting left over
			$changed = true && !$_unchanged;
			$_unchanged = false;
			}
		}
	if (in_edict($verb)) return $verb;
	else if (!$changed or strlen($verb) == 0) die ($_verb . ": not in dictionary");
	else $r = deinflect($verb);
	return $r;
	}
	
?>