package ash.util;

import java.io.PrintStream;

/**
 * [eBeB\bh
 */
public class Log {
	static final PrintStream STDERR = System.err; // N[̕WG[
	static PrintStream err = System.err;

	static private void printTrace(int level, String message) {
		((level < 0) ? STDERR : err).println(message);
	}
	/* fobObZ[W̕\
	 * debugLevel̒lɂā@debug(level, ...)  trace(level, ) ɂ
	 * bZ[W\𐧌䂷B
	 *  debugLevel <  10   ̏ꍇFlevel <= debugLevel ȂΕ\
	 *  debugLevel >= 10   ̏ꍇF
	 *    debugLevel/10 == level/10 ̏ꍇF
	 *      Pڂ̐Е0ȂΕ\B
	 *    ȊȌꍇ͕\Ȃ
	 */
	private static int debugLevel = 0;
	public static boolean check(int level) {
		if(level < 0) level = -level;
		if(debugLevel < 10) return (level <= debugLevel);
		if(debugLevel/10 == level/10) {
			int d = debugLevel % 10;
			int l = level % 10;
			return (d == 0 || l == 0 || d == l);
		}
		return false;
	}
	/**
	 * fobOx擾B
	 */
	public static int getDebugLevel() {
		return debugLevel;
	}
	/**
	 * fobOxݒ肷B
	 * @param level fobOx
	 * <p> level < 0  ̏ꍇ: N[֕\B
	 */
	public static void setDebugLevel(int level) {
		if(level >= 0) {		// AshConsole ֕\
			err = System.err;
		} else if(level < 0) {	// N[֕\
			level = -level;
			err = STDERR;
		}
		debugLevel = level;
		assert debug(9,    "fobOx 9");
		assert debug(100,  "fobOx 100");
		assert debug(101,  "fobOx 101");
		assert debug(109,  "fobOx 109");
		assert debug(-101, "fobOx -101");
	}
	/**
	 * fobO\xɉăfobOs\
	 * @param level \xȉꍇ͋N[֕\j
	 * @param message fobOs
	 */
	public static boolean debug(int level, String message) {
		if(check(level)) printTrace(level, message);
		return true;
	}
	/**
	 * Throwabel(Exception/Error)\B
	 * @param e OG[
	 */
	public static boolean debug(Throwable e) {
		if(debugLevel == 0) {
			printTrace(0, e.toString());
		} else {
			e.printStackTrace(err);
		}
		return true;
	}
	/**
	 * fobOsThrowable \B
	 */
	public static boolean debug(Throwable e, int level, String message) {
		debug(level, message);
		debug(e);
		return true;
	}
	/**
	 * fobO\xɉăXbhƋɃg[X\B
	 * @param level \xȉꍇ͋N[֕\j
	 * @param message fobOs
	 */
	public static boolean trace(int level, String message) {
		if(check(level)) printTrace(level, "" + thread() + " " + message);
		return true;
	}
	public static boolean trace(int level, String message, Thread th) {
		return trace(level, message + thread(th));
	}
	public static String thread() {
		//return Thread.currentThread().toString().substring(6);
		return thread(Thread.currentThread());
	}
	public static String thread(Thread th) {
		return String.format("[%-6s]", th.getName());
	}
}
