package ash.reverse.uml;
import java.util.regex.Pattern;
import java.awt.Font;
import static java.awt.Font.*;
import java.awt.FontMetrics;
import javax.swing.JLabel;

/**
 * UMLNX}o͂ŕKvȒ萔`B
 */
interface UMLConst {
	final static String SEP = "\t";			// UMLt@C`̃Zp[^
	final static String DUMMY = SEP+"null";	// _~[
	final static String NAVI = SEP+"true";	// _~[
	final static String RELPARAMS = DUMMY + DUMMY + DUMMY + NAVI + DUMMY + DUMMY;
	final static int UNIT = 8;

	final static Font DEFAULT_FONT = new Font(SERIF, PLAIN, 14);
	final static FontMetrics DEFAULT_FONTMETRICS =
		new JLabel().getFontMetrics(DEFAULT_FONT);

	final static String OPTIONAL = "0..1";	// IvViȑdx
	final static String MULTIVALUED = "*";	// l̑dx

	/**
	 * UMLNX}t@CtH[}bgŎgp^O
	 */
	final static String EXTENDS = "EXTENDS";
	final static String ASSOCIATION = "ASSOC";
	final static String INNER = "INNER";
	final static String DEPENDS = "DEPENDS";
	final static String ATTRIBUTE = "ATTRIB";
	final static String METHOD = "METHOD";
	final static String PARAMETER = "PARAM";
	final static String ENUM_TYPE = "$EnumValue";

	/**
	 * ˑ֌W̒^IȎ
	 */
	enum Stereotype {
		NEW("<new>"),
		BODY("<body>"),
		PARAM("<param>"),
		RETURN("<return>"),
		;
		String label;
		Stereotype(String label) { this.label = label; }
		static Stereotype value(String token) {
			for(Stereotype v : values()) {
				if(token.equals(v.label)) return v;
			}
			return null;
		}
	}
}
