package ash.reverse.parser;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.struct.GroupRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.FieldRecord;

/**
 * Javã\[XR[hp[YíjALOCƃNXE\bhEtB[h
 * 𒊏oB
 * <p>
 * RXgN^Ńt@Cw肵Aparse()\bhŃp[YJnB
 * p[Y̌ʂ͖߂lFileRecord̒ɋL^B
 * <p>
 * ӐioOjF
 * <ul>
 * <li> ͂t@ĆAJava̍\Iɐ\[XR[h
 * Ȃ΂ȂȂB
 * <li> 1̃tB[h`ŕ̃tB[h`ꍇ́A
 * K؂ȉ͂sȂB
 * <li> le_eƂȂB
 * 񋓌^̒l͌^ENUM_TYPEƂtB[hƂċL^B
 * </ul>
 */
public class JavaParser extends JavaTokenizer {
	/**
	 * RXgN^ł͎w̃[_Javã\[XR[hǂݎ͂
	 * Jn鏀sBt@C̓G[bZ[W̒ŎQƂB
	 * @param reader \[Xt@Cǂݎ邽߂̃[_[
	 * @param fname \[Xt@C
	 * @param signature VOj`̒oKvȏꍇtrue
	 */
	public JavaParser(Reader reader, String fname, boolean signature) {
		super(reader, fname);
		this.signature = signature;
		if(signature) makeSignature();
	}
	/**
	 * |[gɕKvȏ
	 */
	private boolean signature;			// VOj`𒊏oꍇtrue
	private GroupRecord currentClass;	// ݉͒̃NX

	/**
	 * \G[ɃG[gݗĂB
	 * eNX̏Ɍݏ̃NX̏ǉB
	 */
	@Override protected String getErrorInfo() {
		String msg = super.getErrorInfo();
		if(currentClass != null)
			msg += "\n" + currentClass.errMessage();
		return msg;
	}

	/** ݉͒̑Ώۂ̉ */
	private Visibility visibility;

	/** ݉͒̑Ώۂ̏C */
	private int modifiers;

	/**
	 * VOj`o^JnB
	 */
	@Override protected void startSignature() {
		super.startSignature();
		visibility = Visibility.PACKAGE;
		modifiers = 0;
	}

	/**
	 * g[NCqȂ΂L^B
	 * @param token g[N
	 * @return g[NCqȂtrue
	 */
	private boolean gleanProp(String token) {
		Visibility vis = Visibility.value(token);
		if(vis != Visibility.UNDEF) {
			visibility = vis;
			return true;
		}
		int mask = Mod.mask(token);
		modifiers |= mask;
		return mask != 0;
	}

	/**
	 * Cqݒ肷B
	 */
	private void setPropTo(ObjectRecord rec) {
		rec.visibility(visibility);
		rec.modifiers(modifiers);
	}

	/**
	 * Java\[Xt@C̃gbvx͂B
	 * NXAC^tF[XA񋓌^̃L[[hǂݎA
	 * NXp[Y̏ԂɑJڂB
	 * @return p[Y̌ʂL^t@CL^
	 */
	public FileRecord parse() throws IOException {
		FileRecord fileRec = new FileRecord(fname);
		// trace("@@@ " + fname);
		startSignature();
		while(true) {
			switch(getToken()) {
			case TT_EOF:
				fileRec.addLoc(nLine);
				fileRec.setLineEnd(nLine + nSpaceLine);
				return fileRec;
			case TT_WORD:
				String token = this.sval;
				if(token.equals("package")) {
					startSignature();
					while(getToken() != ';') {}
					fileRec.pkgname(pruneSignature());
					startSignature();
				} else if(token.equals("import") && signature) {
					startSignature();
					while(getToken() != ';') {}
					fileRec.addImportDecl(pruneSignature());
					startSignature();
				} else if(JavaType.valid(token)) {
					parseClass(fileRec);
					startSignature();
				} else if(token.startsWith("@")) {
					parseAnnotation();	// Ame[VQ(ex. @Target)
				} else {
					gleanProp(token);
				}
				break;
			case ';':					// package/import̏I
				startSignature();
				break;
			}
		}
	}

	/**
	 * NXp[YԁF
	 * NX`p[YAȉ̏sB
	 * <ul>
	 * <li>NXp[YԂɓۂɁANX̋L^Ȃǂ̏sB
	 * <li>Ci[NX̒`̊Jn𔻒肵AVNXp[Y̏Ԃ
	 * JڂB
	 * <li>\bhiRXgN^j`̊Jn𔻒肵A\bhp[Y̏Ԃ
	 * JڂB
	 * <li>NX`̏I𔻒肵ANXp[Y̏ԂEoB
	 * </ul>
	 * @param owner ͒̃NXLĂO[v
	 */
	private void parseClass(GroupRecord owner) throws IOException {
		String type = this.sval;
		getToken();
		ClassRecord theClass =
			new ClassRecord(type, this.sval, this.lineno(), owner);
		setPropTo(theClass);
		currentClass = theClass;
		owner.addMember(theClass);
		while(getToken() != '{') {} 
		theClass.setSignature(pruneSignature());
		parseClassBody(theClass);
		currentClass = owner;
	}
	/**
	 * NX{̂p[YB
	 * @param theClass ݃p[ỸNX̏
	 */
	private void parseClassBody(ClassRecord theClass) throws IOException {
		int level = blockLevel;
		int startLine = nLine;
		String typeCnadidate = null;
		String memberCandidate = null;
		startSignature();

		if(theClass.isEnum()) {
			parseEnumValue(theClass);
			if(this.ttype == '}') pushBack();
		}

		while(true) {
			switch(getToken()) {
			case TT_WORD:
				if(JavaType.valid(this.sval)) {
					parseClass(theClass);			// Ci[NX
					break;
				}
				if(this.sval.startsWith("@")) {		// Ame[V Q
					parseAnnotation();
				} else if(!gleanProp(this.sval)) {
					typeCnadidate = memberCandidate;
					memberCandidate = this.sval;	// \bȟ
				}
				continue;
			case ';':
				if(memberCandidate != null)
					addFieldDecl(theClass, memberCandidate);
				break;
			case '=':								// tB[hϐ̏lݒ
				parseFieldExpr(theClass, memberCandidate);
				break;
			case '(':								// \bh`
				parseMethod(theClass, memberCandidate);
				break;
			case '{':								// q
				if(memberCandidate == null) {
					this.pushBack();
					parseMethod(theClass, null);
				}
				break;
			case '}':
				if(blockLevel < level) {			// NX`̏I
					theClass.setLineEnd(this.lineno());
					theClass.addLoc(nLine - startLine + 1);
					return;
				}
				// FALLTHROUGH
			default:
				continue;
			}
			typeCnadidate = memberCandidate = null;
			startSignature();
		}
	}

	/**
	 * 񋓌^̒lp[YClassRecord#enumListɓo^B
	 * @param theClass ݃p[ỸNX̏
	 */
	private void parseEnumValue(ClassRecord theClass) throws IOException {
		// enum E { V1(...), V2(...), ...; ...}
		String enumValue = null;
		int startLevel = parenLevel;
		while(true) {
			switch(getToken()) {
			case ',':
				if(parenLevel > startLevel) break;
			case ';':
			case '}':
				if(enumValue != null) theClass.addEnum(enumValue);
				if(this.ttype == ';' || this.ttype == '}') return;
				enumValue = null;
				break;
			case TT_WORD:
				if(parenLevel == startLevel) enumValue = this.sval;
				break;
			}
		}
	}

	/**
	 * tB[hϐ`o^B
	 * @param theClass ݃p[ỸNX̏
	 * @param name tB[h
	 */
	private void addFieldDecl(ClassRecord theClass, String name) {
		//trace("field : " + name);
		int lineno = this.lineno();
		FieldRecord theField = new FieldRecord(name, lineno, theClass);
		setPropTo(theField);
		theClass.addMember(theField);
		theField.addLoc(1);
		theField.setLineEnd(lineno);
		theField.setFieldDecl(pruneSignature());
	}
	/**
	 * ̂tB[hϐ`p[Yo^B
	 * @param theClass ݃p[ỸNX̏
	 * @param name tB[h
	 */
	private void parseFieldExpr(ClassRecord theClass, String name)
		throws IOException {
		//trace("field = " + name);
		FieldRecord theField = new FieldRecord(name, this.lineno(), theClass);
		setPropTo(theField);
		theClass.addMember(theField);
		String fieldDecl = pruneSignature();
		if(fieldDecl.endsWith("=")) 
			fieldDecl = fieldDecl.substring(0, fieldDecl.length()-1);
		theField.setFieldDecl(fieldDecl);

		int startLine = nLine;
		int level = blockLevel;
		boolean blockInitialize = false;
		startSignature();
		while(true) {
			getToken();
			if(level == blockLevel) {
				if(this.ttype == ';') break;
				if(this.ttype == TT_WORD) {
					theField.addToken(this.sval);
					if(this.sval.equals("new")) {	// new T ?
						getToken();					
						theField.addToken(this.sval);	// ^To^
						parseNewClass(theClass);
					}
				}
			} else {
				blockInitialize = true;
			}
		}
		theField.addLoc(nLine - startLine + 1);
		theField.setLineEnd(this.lineno());

		String initExpr = pruneSignature();
		if(blockInitialize) initExpr = "{...}";
		if(!initExpr.equals("}")) theField.value(initExpr);
	}
	/**
	 * "new ClassX" ȍ~̃g[Np[YB
	 * new ClassX(...) {...} ̌`ł́ANX̃\bhp[YB
	 * @param theClass ݃p[ỸNX̏
	 */
	private void parseNewClass(ClassRecord theClass) throws IOException {
		while(true) {
			switch(getToken()) {
			case '(':					// new ClassX(
				parseNewParen();		// new ClassX(...)
				if(getToken() == '{') { // new ClassX(...) {	// NX
					parseClassBody(theClass);
					// new ClassX(...) {...}
				} else {				// new ClassX(...);
					this.pushBack();
				}
				return;
			case '{':					// new ClassX[] {
				int level = blockLevel;
				do { getToken(); } while(blockLevel >= level);
				// new ClassX[] {...}
				return;
			case ';':					// new ClassX[];
				this.pushBack();
				return;
			}
		}
	}

	/**
	 * RXgN^Ăяoɂp[YB
	 */
	private void parseNewParen() throws IOException {
		int startLevel = parenLevel;
		boolean blockEaten = false;	// CA,20111123
		do {
			int ttype = getToken();
			if(ttype == '{') blockEaten = true;
		} while(startLevel <= parenLevel);
		if(blockEaten) appendCloser("{})");
	}

	/**
	 * \bhp[YԁF
	 * \bh`p[YAȉ̏sB
	 * <ul>
	 * <li>\bhp[YԂɓۂɁA\bh̋L^Ȃǂ̏sB
	 * <li>ۃ\bh𔻒肵A\bhp[Y̏ԂEoB
	 * <li>ubNx烁\bhubN{̂̊JnƔ肷B
	 * <li>ubNxJnɖ߂烁\bh`̏IƔ肷B
	 * </ul>
	 * @param theClass ݃p[ỸNX̏
	 * @param name \bh
	 */
	private void parseMethod(ClassRecord theClass, String name)
		throws IOException {
		if(name == null) {						// q
			name = Mod.STATIC.in(modifiers) ? "static{}" : "instance{}";
		}
		MethodRecord method = theClass.addMethod(name, this.lineno());
		setPropTo(method);
		int startLine = nLine;
		int level = blockLevel;
		boolean inBody = false;
		if(!name.endsWith("{}")) parseParen();
		while(true) {
			getToken();
			if(!inBody) {
				if(this.ttype == ';') break;	// ۃ\bh̏I
				if(blockLevel > level)			// \bh{̂̊Jn
					inBody = true;
			} else {
				if(blockLevel == level) break;	// \bh`̏I
				if(signature && this.ttype == TT_WORD) {
					//trace("@@@ " + this.sval);
					theClass.addMethodToken(this.sval);
				}
			}
		}		
		theClass.setMethodLoc(nLine - startLine + 1, this.lineno());

		String sig = pruneSignature();
		if(sig.isEmpty()) sig = "instance()" ;
		if(sig.equals("static")) sig = "static()";
		theClass.setMethodSignature(sig);
	}

	/**
	 * Ame[VQƂp[YB
	 * ex. @Documented @Target({TYPE, FIELD, METHOD})
	 *                 ^      ^
	 */
	private void parseAnnotation() throws IOException {
		appendSignature("\t");
		if(getToken() == '(') {
			startAnnotation();
			parseParen();
			endAnnotation();
			appendSignature("\t");
		} else {
			this.pushBack();
		}
	}
	/**
	 * Eۊʂ܂łp[Y`obt@ɒǉB
	 */
	private void parseParen() throws IOException {
		int startLevel = parenLevel;
		do { getToken(); } while(startLevel <= parenLevel);
	}
}
