package ash.gui.editor.core;
import java.awt.Font;
import static java.awt.Font.*;
import javax.swing.JFrame;
import javax.swing.JDialog;
import javax.swing.JButton;
import javax.swing.JComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ash.gui.core.AshGroupPanel;
import ash.gui.core.AshFont;

/**
 * tHgݒ_CAO
 */
@SuppressWarnings("serial")
public class AshFontPanel extends AshGroupPanel implements ActionListener {
	public static Font updateFont(JFrame frame, Font font) {
		JDialog dialog = new JDialog(frame, "tHgI", true);
		AshFontPanel fp = new AshFontPanel(dialog, font);
		dialog.setContentPane(fp);
		//dialog.setResizable(false);
		dialog.pack();
		dialog.setLocationRelativeTo(frame);	// EBhE𒆉ɔzu
		dialog.setVisible(true);
		dialog.dispose();
		return (fp.createdFont != null) ? fp.createdFont : font;
	}

	static private String[] styleList = { "W", "", "Α", " Α" };
	static private Integer[] sizeList = { 10,12,14, 16, 18, 20, 22, 24, 26, 28 };
	static private int[] fontStyles = { PLAIN, BOLD, ITALIC, ITALIC | BOLD };
	private JComboBox fontCombo  = combobox(AshFont.nameList);
	private JComboBox styleCombo = combobox(styleList);
	private JComboBox sizeCombo  = combobox(sizeList);
	private JButton ok, cancel;
	private JDialog dialog;
	private Font createdFont = null;

	AshFontPanel(JDialog dialog, Font font) {
		this.dialog = dialog;
		fontCombo.setSelectedItem(font.getName());
		styleCombo.setSelectedIndex(findStyleIndex(font.getStyle()));
		sizeCombo.setSelectedItem(font.getSize());
		setActionListener(this);
		ok = button("");
		cancel = button("");
		//           tHgIĂB
		// ̖    [                        ] 
		// X^C  [                ] 
		// TCY    [        ] 
		//           ()    ()
		form(line(null,       "tHgIĂB"),
			 line("̖",   fontCombo),
			 line("X^C", sg(styleCombo, gap(40))),
			 line("TCY",   sg(sizeCombo, gap(80))),
			 line(null,       sg(ok, gap(20), cancel, gap(20))));
	}
	// {^CxgŃ_CAO
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			String fontName = AshFont.nameList[fontCombo.getSelectedIndex()];
			int fontStyle = fontStyles[styleCombo.getSelectedIndex()];
			int fontSize = sizeList[sizeCombo.getSelectedIndex()];
			createdFont = new Font(fontName, fontStyle, fontSize);
		}
		dialog.dispose();
	}
	private int findStyleIndex(int fontStyle) {
		for(int i = 0; i < fontStyles.length; i++) {
			if(fontStyles[i] == fontStyle) return i;
		}
		return 0;
	}
}
