package ash.gui.core;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.awt.Font;
import static java.awt.Font.*;
import javax.swing.JComponent;
import ash.util.Log;

/**
 * tHgǗNXB
 * AshPanel ̈ȉ̃R|[lg\bhŗpB
 * field, password, textarea
 */
public class AshFont {
	public static final String FIXED_FONT = "Monospaced";
	public static final String MS_FIXED_FONT = "MS Gothic";
	public static final String MAC_FIXED_FONT = "monaco";
	private static Font defaultFont = new Font(FIXED_FONT, PLAIN, 14);
	public static String[] nameList = { MONOSPACED, "MS Gothic", "MS Mincho" };
	static {
		String os = System.getProperty("os.name");
		if(os.startsWith("Windows")) {
			defaultFont = new Font(MS_FIXED_FONT, PLAIN, 14);
			nameList = new String[] { MONOSPACED, "MS Gothic", "MS Mincho" };
		} else if(os.startsWith("Mac")) {
			defaultFont = new Font(MAC_FIXED_FONT, PLAIN, 12);
			nameList = new String[] { MONOSPACED, "monaco", "Osaka|" };
		}
	}
	public static Font getFont() { return defaultFont; }

	static public final String[] FONT_NAME_TABLE = {
		"Default", DIALOG, DIALOG_INPUT, MONOSPACED, SERIF, SANS_SERIF
	};
	// new AshFont("name@BI20%MS Gothic")
	static final String FONTDEF = "([^@]*)@([BISML]*)(\\d*)(#(\\d+)|%(.+))?$";
	//                             @1      @2        @3     @5       @6
	static private Pattern fontDefPat = Pattern.compile(FONTDEF);
	private String text;
	public String getText() { return text; }
	private Font font;

	/**
	 * tHgw܂ރeLXgAeLXgƃtHgoB
	 * @param text tHgweLXg̎dlF
	 * <text>?@[BISML]*<font-size>?(#<font-id>|%<font-name>)?
	 */
	public AshFont(String text) {
		Matcher m = fontDefPat.matcher(text);
		if(m.find()) {
			this.text = m.group(1);
			if(this.text == null) this.text = "";
			font = makeFont(findFontName(m), m.group(2), m.group(3));
		} else {
			this.text = text;
		}
	}
	// (#<font-id>|%<font-name>)
	private String findFontName(Matcher m) {
		String fontName = m.group(6);			// %<font-name>
		if(fontName != null) return fontName;
		String fontId = m.group(5);				// #<font-id>
		int fid = 0;
		try { fid = Integer.parseInt(fontId); } catch(Exception e) {}
		if(fid >= FONT_NAME_TABLE.length) {
			Log.debug(0, "AshFont#findFont(): WARINING: fontID=" + fid);
			fid = 0;
		}
		return FONT_NAME_TABLE[fid];
	}
	public JComponent setFont(JComponent compo) {
		if(font == null) return null;
		compo.setFont(font);
		return compo;
	}
	public Font getTextFont() { return font; }

	static private Font makeFont(String name, String fontSig, String sizeStr) {
		int style = 0;
		int size = 14;
		if(fontSig != null) {
			for(char c : fontSig.toCharArray()) {
				switch(c) {
				case 'B': style |= BOLD; break;
				case 'I': style |= ITALIC; break;
				case 'S': size = 10; break;
				case 'M': size = 14; break;
				case 'L': size = 20; break;
				}
			}
		}
		if(sizeStr != null)
			try { size = Integer.parseInt(sizeStr); } catch(Exception e) {}
		Log.debug(95, String.format("%-16s #%d\n", name, size));
		return new Font(name, style, size);
	}
}
