/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import ash.util.Log;
import ash.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;

public class FileUtil {
    private static final int FILE_LINES = 2048;
    private static File tmpDir = null;
    private static int tmpFileSerial = 0;

    public static BufferedReader openReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedWriter openWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter(fileOutputStream));
    }

    public static BufferedWriter openWriter(File file, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        return new BufferedWriter(new OutputStreamWriter(fileOutputStream));
    }

    public static String lastModified(File file) {
        Date date = file == null ? null : new Date(file.lastModified());
        return Util.formatDate(date);
    }

    public static String[] readStringArray(File file) {
        try {
            return FileUtil.readStringArrayEx(file);
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringArrayEx(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList<String> arrayList = new ArrayList<String>(2048);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            String[] stringArray = Util.toArray(arrayList);
            return stringArray;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringArray(String[] stringArray, File file) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = FileUtil.openWriter(file);
            for (String string : stringArray) {
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
        }
        finally {
            if (bufferedWriter != null && file != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = FileUtil.openReader(file);
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeText(String string, File file) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = FileUtil.openWriter(file);
            bufferedWriter.write(string, 0, string.length());
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getFullPath(File file) {
        try {
            String string = FileUtil.normalPath(file.getCanonicalPath());
            if (!file.isDirectory()) {
                return string;
            }
            return string + "/";
        }
        catch (IOException iOException) {
            return FileUtil.getPath(file);
        }
    }

    public static String getPath(File file, File file2) {
        String string;
        if (file == null) {
            return "./";
        }
        String string2 = FileUtil.getFullPath(file);
        if (!string2.startsWith(string = FileUtil.getFullPath(file2))) {
            return string2;
        }
        if (string2.equals(string)) {
            return "./";
        }
        return string2.substring(string.length());
    }

    public static String getFullPathU(File file) {
        try {
            return FileUtil.normalPath(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return FileUtil.normalPath(file.getPath());
        }
    }

    public static String getPath(File file) {
        String string = FileUtil.normalPath(file.getPath());
        if (file.isDirectory()) {
            return string + "/";
        }
        return string;
    }

    public static String normalPath(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static String getSuffix(String string) {
        int n;
        if (string.endsWith("/")) {
            return null;
        }
        int n2 = Math.max(string.lastIndexOf(47), string.indexOf(58));
        int n3 = n2 < 0 ? 0 : n2 + 1;
        if (n3 <= (n = string.lastIndexOf(46))) {
            String string2 = string.substring(n + 1);
            return string2.toLowerCase();
        }
        return null;
    }

    public static synchronized File createTempFile() throws IOException {
        File file;
        if (tmpDir == null) {
            tmpDir = new File(".tmpfiles");
        }
        if (!tmpDir.exists() || !tmpDir.mkdir()) {
            tmpDir = new File(".");
        }
        do {
            file = new File(tmpDir, "ash.tmp#" + ++tmpFileSerial);
            Log.debug(1, "tmpFile=" + file);
        } while (file.exists());
        return file;
    }

    public static ImageIcon makeImageIcon(Class clazz, String string) {
        URL uRL = FileUtil.getResource(clazz, "images/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static URL getResource(Class clazz, String string) {
        URL uRL = FileUtil.getClassLoader(clazz).getResource(string);
        if (uRL == null) {
            System.err.println("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093: " + string);
        }
        return uRL;
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        return classLoader;
    }
}

