/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.struct;

import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.ObjectRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GroupRecord
extends ObjectRecord {
    List<ObjectRecord> members = new ArrayList<ObjectRecord>();
    private Map<String, ClassRecord> typeMap;

    public List<ObjectRecord> members() {
        return this.members;
    }

    GroupRecord(String string, String string2, int n, GroupRecord groupRecord) {
        super(string, string2, n, groupRecord);
    }

    public void addMember(ObjectRecord objectRecord) {
        this.members.add(objectRecord);
    }

    public ClassRecord findType(String string) {
        ClassRecord classRecord = this.getTypes().get(string);
        if (classRecord != null) {
            return classRecord;
        }
        if (this.owner() == null) {
            return null;
        }
        return this.owner().findType(string);
    }

    private Map<String, ClassRecord> getTypes() {
        if (this.typeMap != null) {
            return this.typeMap;
        }
        this.typeMap = new HashMap<String, ClassRecord>();
        for (ObjectRecord objectRecord : this.members) {
            if (!(objectRecord instanceof ClassRecord)) continue;
            this.typeMap.put(objectRecord.name, (ClassRecord)objectRecord);
        }
        return this.typeMap;
    }

    public void printTypes(String string) {
        this.trace(string + this.name);
        for (ObjectRecord objectRecord : this.members()) {
            if (!(objectRecord instanceof ClassRecord)) continue;
            ((ClassRecord)objectRecord).printTypes(string + "\t");
        }
    }

    @Override
    protected int countMethods() {
        int n = 0;
        for (ObjectRecord objectRecord : this.members) {
            n += objectRecord.countMethods();
        }
        return n;
    }

    @Override
    protected int sumMethodLoc() {
        int n = 0;
        for (ObjectRecord objectRecord : this.members) {
            n += objectRecord.sumMethodLoc();
        }
        return n;
    }
}

