/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.parser;

public final class Mod
extends Enum<Mod> {
    public static final /* enum */ Mod ABSTRACT = new Mod("abstract");
    public static final /* enum */ Mod STATIC = new Mod("static");
    public static final /* enum */ Mod FINAL = new Mod("final");
    public static final /* enum */ Mod NATIVE = new Mod("native");
    public static final /* enum */ Mod STRICTFP = new Mod("strictfp");
    public static final /* enum */ Mod SYNCHRONIZED = new Mod("synchronized");
    public static final /* enum */ Mod TRANSIENT = new Mod("transient");
    public static final /* enum */ Mod VOLATILE = new Mod("volatile");
    public static final /* enum */ Mod UNDEF = new Mod("????");
    public final String keyword;
    private int index;
    private static int seq;
    private static final /* synthetic */ Mod[] $VALUES;

    public static Mod[] values() {
        return (Mod[])$VALUES.clone();
    }

    public static Mod valueOf(String string) {
        return Enum.valueOf(Mod.class, string);
    }

    private Mod(String string2) {
        this.keyword = string2;
    }

    public static void main(String[] stringArray) {
        Mod.print("native -> " + (Object)((Object)Mod.value("native")));
        Mod.print("whatisthis -> " + (Object)((Object)Mod.value("whatisthis")));
        Mod.print("#native -> " + Mod.index("native"));
        Mod.print("#whatisthis -> " + Mod.index("whatisthis"));
        for (Mod mod : Mod.values()) {
            Mod.print(mod.name() + ": " + mod.keyword + ", index = " + mod.index() + ", mask = " + mod.mask());
        }
        int n = 0;
        n |= Mod.mask("static");
        n |= Mod.mask("final");
        Mod.print("modifiers=" + (n |= Mod.mask("synchronized")));
        Mod.print("modifiers=" + (n |= Mod.mask("whatisthis")));
        Mod.print("'" + Mod.toCode(n) + "'");
        assert (STATIC.in(n)) : "Mod.STATIC.in(modifiers)";
        assert (!UNDEF.in(n)) : "Mod.UNDEF.in(modifiers)";
        assert (!TRANSIENT.in(n)) : "Mod.TRANSIENT.in(modifiers)";
    }

    private static void print(Object object) {
        System.out.println(object);
    }

    public String keyword() {
        return this.keyword;
    }

    public int index() {
        return this.index;
    }

    public int mask() {
        return 1 << this.index;
    }

    public boolean in(int n) {
        return this != UNDEF && (n & 1 << this.index) != 0;
    }

    public static Mod value(String string) {
        for (Mod mod : Mod.values()) {
            if (!mod.keyword.equals(string)) continue;
            return mod;
        }
        return UNDEF;
    }

    static int index(String string) {
        Mod mod = Mod.value(string);
        if (mod == UNDEF) {
            return -1;
        }
        return mod.index;
    }

    public static int mask(String string) {
        int n = Mod.index(string);
        if (n < 0) {
            return 0;
        }
        return 1 << n;
    }

    public static String toCode(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Mod mod : Mod.values()) {
            if ((n & mod.mask()) == 0) continue;
            stringBuilder.append(mod.keyword + " ");
        }
        return stringBuilder.toString();
    }

    static {
        $VALUES = new Mod[]{ABSTRACT, STATIC, FINAL, NATIVE, STRICTFP, SYNCHRONIZED, TRANSIENT, VOLATILE, UNDEF};
        seq = 0;
        for (Mod mod : Mod.values()) {
            ++seq;
            mod.index = mod.index;
        }
    }
}

