/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.util.Log;
import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class AshFont {
    public static final String FIXED_FONT = "Monospaced";
    public static final String MS_FIXED_FONT = "MS Gothic";
    public static final String MAC_FIXED_FONT = "monaco";
    private static Font defaultFont = new Font("Monospaced", 0, 14);
    public static String[] nameList = new String[]{"Monospaced", "MS Gothic", "MS Mincho"};
    public static final String[] FONT_NAME_TABLE;
    static final String FONTDEF = "([^@]*)@([BISML]*)(\\d*)(#(\\d+)|%(.+))?$";
    private static Pattern fontDefPat;
    private String text;
    private Font font;

    public static Font getFont() {
        return defaultFont;
    }

    public String getText() {
        return this.text;
    }

    public AshFont(String string) {
        Matcher matcher = fontDefPat.matcher(string);
        if (matcher.find()) {
            this.text = matcher.group(1);
            if (this.text == null) {
                this.text = "";
            }
            this.font = AshFont.makeFont(this.findFontName(matcher), matcher.group(2), matcher.group(3));
        } else {
            this.text = string;
        }
    }

    private String findFontName(Matcher matcher) {
        String string = matcher.group(6);
        if (string != null) {
            return string;
        }
        String string2 = matcher.group(5);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= FONT_NAME_TABLE.length) {
            Log.debug(0, "AshFont#findFont(): WARINING: fontID=" + n);
            n = 0;
        }
        return FONT_NAME_TABLE[n];
    }

    public JComponent setFont(JComponent jComponent) {
        if (this.font == null) {
            return null;
        }
        jComponent.setFont(this.font);
        return jComponent;
    }

    public Font getTextFont() {
        return this.font;
    }

    private static Font makeFont(String string, String string2, String string3) {
        int n = 0;
        int n2 = 14;
        if (string2 != null) {
            block9: for (char c : string2.toCharArray()) {
                switch (c) {
                    case 'B': {
                        n |= 1;
                        continue block9;
                    }
                    case 'I': {
                        n |= 2;
                        continue block9;
                    }
                    case 'S': {
                        n2 = 10;
                        continue block9;
                    }
                    case 'M': {
                        n2 = 14;
                        continue block9;
                    }
                    case 'L': {
                        n2 = 20;
                    }
                }
            }
        }
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.debug(95, String.format("%-16s #%d\n", string, n2));
        return new Font(string, n, n2);
    }

    static {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            defaultFont = new Font(MS_FIXED_FONT, 0, 14);
            nameList = new String[]{FIXED_FONT, MS_FIXED_FONT, "MS Mincho"};
        } else if (string.startsWith("Mac")) {
            defaultFont = new Font(MAC_FIXED_FONT, 0, 12);
            nameList = new String[]{FIXED_FONT, MAC_FIXED_FONT, "Osaka\uff0d\u7b49\u5e45"};
        }
        FONT_NAME_TABLE = new String[]{"Default", "Dialog", "DialogInput", FIXED_FONT, "Serif", "SansSerif"};
        fontDefPat = Pattern.compile(FONTDEF);
    }
}

