/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.common;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;

public class FileUtil
implements CommonConst {
    public static void deleteDir(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isFile()) {
                file2.delete();
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileUtil.deleteDir(file2);
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(string);
            while ((n = fileReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                fileReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public static Map<String, Integer> getUserDefClass(List<String> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : list) {
            if (!FileUtil.isClass(string)) continue;
            String[] stringArray = string.split("\t");
            if (Util.hasSymbol(stringArray[2])) {
                List<String> list2 = Util.getTypeList(stringArray[2]);
                hashMap.put(list2.get(0), Integer.valueOf(stringArray[1]));
                continue;
            }
            hashMap.put(stringArray[2], Integer.valueOf(stringArray[1]));
        }
        return hashMap;
    }

    public static Set<String> getAllTypeSet(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : list) {
            List<String> list2;
            String[] stringArray;
            if (FileUtil.isClass(string)) {
                stringArray = string.split("\t");
                list2 = Util.getTypeList(stringArray[2]);
                hashSet.addAll(list2);
            }
            if (FileUtil.isAttrib(string)) {
                stringArray = string.split("\t");
                hashSet.addAll(Util.getTypeList(stringArray[2]));
            }
            if (FileUtil.isMethod(string)) {
                stringArray = string.split("\t");
                list2 = Util.getTypeList(stringArray[2]);
                list2.remove("null");
                hashSet.addAll(list2);
            }
            if (!FileUtil.isParam(string)) continue;
            stringArray = string.split("\t");
            hashSet.addAll(Util.getTypeList(stringArray[2]));
        }
        return hashSet;
    }

    public static int getMaxClassId(Map<String, Integer> map) {
        int n = 0;
        for (Integer n2 : map.values()) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static boolean isClass(String string) {
        return string.startsWith(CommonConst.ClassType.CLASS.alias()) || string.startsWith(CommonConst.ClassType.ABSTRACT_CLASS.alias()) || string.startsWith(CommonConst.ClassType.INTERFACE.alias()) || string.startsWith(CommonConst.ClassType.ENUM.alias());
    }

    public static boolean isAttrib(String string) {
        return string.startsWith(CommonConst.MethodAndAttrType.ATTRIB.alias());
    }

    public static boolean isMethod(String string) {
        return string.startsWith(CommonConst.MethodAndAttrType.ABSTRACT_METHOD.alias()) || string.startsWith(CommonConst.MethodAndAttrType.METHOD.alias());
    }

    public static boolean isParam(String string) {
        return string.startsWith(CommonConst.MethodAndAttrType.PARAM.alias());
    }

    public static boolean isArc(String string) {
        return string.startsWith(CommonConst.AssocType.ASSOC.alias()) || string.startsWith(CommonConst.AssocType.INNER.alias()) || string.startsWith(CommonConst.AssocType.DEPENDS.alias()) || string.startsWith(CommonConst.AssocType.EXTENDS.alias());
    }

    public static boolean isPackage(String string) {
        return string.startsWith(CommonConst.PackageType.PACKAGE.alias());
    }
}

