/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.gui.core.AshGroupPanel;
import ash.gui.core.AshPanel;
import ash.gui.core.FormModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AshForm
extends AshGroupPanel
implements ActionListener {
    protected int[] width;
    protected String[] title;
    protected FormModel model;

    public AshForm() {
        super(4, 2);
    }

    public AshForm(int[] nArray, String[] stringArray, int n) {
        this();
        this.reset(nArray, stringArray, n);
    }

    public AshForm(int[] nArray, String[] stringArray, int n, String string) {
        this(nArray, stringArray, n);
        this.loadData(string);
    }

    public void reset(int[] nArray, String[] stringArray, int n) {
        this.width = nArray;
        this.title = stringArray;
        this.model = new FormModel(this);
        this.model.setRowSize(n);
        this.construct(this.model.getTable());
    }

    private void construct(List<JTextField[]> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.setActionListener(this);
        arrayList.add(this.makeTitle());
        AshPanel.Gap gap = AshForm.gap(2);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(gap);
            arrayList.add(this.makeLine(i, list));
        }
        this.setPadding(4, 2);
        this.form(arrayList.toArray());
    }

    private List makeTitle() {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        arrayList.add(null);
        for (String string : this.title) {
            arrayList.add(AshForm.label(string));
        }
        return arrayList;
    }

    private List makeLine(int n, List<JTextField[]> list) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add(AshForm.label(String.format("%2d", n + 1)));
        for (JTextField jTextField : list.get(n)) {
            arrayList.add(jTextField);
        }
        this.addComponent(arrayList, n);
        return arrayList;
    }

    public void loadData(String string) {
        if (string != null && !string.isEmpty()) {
            this.model.loadData(string);
        }
    }

    public void clear(String string) {
        this.model.clear(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.doAction(abstractButton.getText(), Integer.parseInt(string));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    protected void addComponent(List<Component> list, int n) {
    }

    protected void doAction(String string, int n) {
    }

    JTextField[] makeFields() {
        JTextField[] jTextFieldArray = new JTextField[this.width.length];
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i] = this.field(this.width[i]);
        }
        return jTextFieldArray;
    }

    public String getText(int n, int n2) {
        return this.getField(n, n2).getText();
    }

    public void setText(int n, int n2, String string) {
        this.getField(n, n2).setText(string);
    }

    public JTextField getField(int n, int n2) {
        return this.model.getTable().get(n)[n2];
    }

    public List<JTextField[]> getTable() {
        return this.model.getTable();
    }

    public List<String[]> getContents() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = this.model.getTable().size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new String[this.width.length];
            boolean bl = true;
            for (int j = 0; j < this.width.length; ++j) {
                stringArray[j] = this.getText(i, j).trim();
                if (stringArray[j].isEmpty()) continue;
                bl = false;
            }
            if (bl) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public void saveData(String string) {
        this.model.saveData(string);
    }
}

