/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.model;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.gui.State;
import pbl2011.model.Attribute;
import pbl2011.model.Method;
import pbl2011.model.PackageManager;
import pbl2011.model.Parameter;
import pbl2011.model.UndoRedoModel;

public abstract class ClassNode
implements CommonConst,
Cloneable {
    public int classId;
    public int packageId;
    public CommonConst.ClassType classType = CommonConst.ClassType.CLASS;
    public String className;
    public CommonConst.VisibilityType visibility;
    public List<Method> methodList = new ArrayList<Method>();
    public List<Attribute> attributeList = new ArrayList<Attribute>();
    public boolean delFlag;
    public boolean isBuiltInClass;
    public Point p;
    public int height1;
    public int height2;
    public int height3;
    public int width;
    public int colorRed;
    public int colorGreen;
    public int colorBlue;
    public UndoRedoModel undoredoModel = new UndoRedoModel();

    public int height() {
        return this.height1 + this.height2 + this.height3;
    }

    public abstract String toString();

    public void moveDelta(int n, int n2, int n3, int n4) {
        this.p.x += n;
        this.p.y += n2;
        if (this.p.x < 0) {
            this.p.x = 0;
        } else if (this.p.x + this.width > n3) {
            this.p.x = n3 - this.width;
        }
        if (this.p.y < 0) {
            this.p.y = 0;
        } else if (this.p.y + this.height() > n4) {
            this.p.y = n4 - this.height();
        }
    }

    public String getPackageName() {
        return PackageManager.getPackageName(this.packageId);
    }

    public void resize(int n, int n2, int n3, int n4, int n5, int n6) {
        this.width = n3;
        this.p.x = n;
        this.p.y = n2;
        this.height1 = n4;
        this.height2 = n5;
        this.height3 = n6;
    }

    public void addMethod() {
        this.methodList.add(new Method("new method", String.valueOf(90000), CommonConst.VisibilityType.PUBLIC));
        this.width = this.calcMinWidth();
        this.height3 = this.calcMinHeigh3();
    }

    public void changeMethod(int n, String string, String string2, CommonConst.VisibilityType visibilityType) {
        Method method = this.methodList.get(n);
        method.change(string, string2, visibilityType);
    }

    public void delMethod(int n) {
        this.methodList.remove(n);
    }

    public void changeMethodSeq(int n, boolean bl) {
        if (bl && n > 0) {
            Method method = this.methodList.remove(n);
            this.methodList.add(n - 1, method);
        } else if (!bl && n < this.methodList.size() - 1) {
            Method method = this.methodList.remove(n);
            this.methodList.add(n + 1, method);
        }
    }

    public void addAttribute() {
        this.attributeList.add(new Attribute("new attribute", String.valueOf(90001), CommonConst.VisibilityType.PRIVATE));
        this.width = this.calcMinWidth();
        this.height2 = this.calcMinHeigh2();
    }

    public void changeAttribute(int n, String string, String string2, CommonConst.VisibilityType visibilityType) {
        Attribute attribute = this.attributeList.get(n);
        attribute.change(string, string2, visibilityType);
    }

    public void delAttribute(int n) {
        this.attributeList.remove(n);
    }

    public void changeAttributeSeq(int n, boolean bl) {
        if (bl && n > 0) {
            Attribute attribute = this.attributeList.remove(n);
            this.attributeList.add(n - 1, attribute);
        } else if (!bl && n < this.attributeList.size() - 1) {
            Attribute attribute = this.attributeList.remove(n);
            this.attributeList.add(n + 1, attribute);
        }
    }

    public void changeParameter(int n, int n2, String string, String string2) {
        Method method = this.methodList.get(n);
        method.changeParameter(n2, string, string2);
    }

    public void addParameter(int n) {
        if (this.methodList.size() > n) {
            Method method = this.methodList.get(n);
            method.addParameter(this.classId);
        }
    }

    public void deleteParameter(int n, int n2) {
        if (this.methodList.size() > n && this.methodList.get((int)n).parameterList.size() > n2) {
            this.methodList.get((int)n).parameterList.remove(n2);
        }
    }

    public void changeParameterSeq(int n, int n2, boolean bl) {
        if (bl && n2 > 0) {
            Parameter parameter = this.methodList.get((int)n).parameterList.remove(n2);
            this.methodList.get((int)n).parameterList.add(n2 - 1, parameter);
        } else if (!bl && n2 > -1 && n2 < this.methodList.get((int)n).parameterList.size() - 1) {
            Parameter parameter = this.methodList.get((int)n).parameterList.remove(n2);
            this.methodList.get((int)n).parameterList.add(n2 + 1, parameter);
        }
    }

    public String visibilityMark() {
        return this.visibility.mark();
    }

    public Rectangle getRectangle() {
        Dimension dimension = new Dimension(this.width, this.height());
        return new Rectangle(this.p, dimension);
    }

    public Point getCenter() {
        return new Point(this.p.x + this.width / 2, this.p.y + this.height() / 2);
    }

    public String typeMark() {
        return this.classType.mark();
    }

    public boolean isClassNode() {
        return this.classType.equals((Object)CommonConst.ClassType.CLASS) || this.classType.equals((Object)CommonConst.ClassType.ABSTRACT_CLASS);
    }

    public boolean isInterfaceNode() {
        return this.classType.equals((Object)CommonConst.ClassType.INTERFACE);
    }

    public String getPackagePhrase() {
        if (this.packageId != PACKAGE_DEFAULT_ID) {
            return CommonConst.PackageType.PACKAGE.code() + " " + this.getPackageName() + ";";
        }
        return "";
    }

    public String getClassdeclarationPhrase() {
        return ("null".equals((Object)this.visibility) ? "" : this.visibility.code()) + " " + this.classType.code() + " " + this.className;
    }

    public void autoAdjust() {
        this.width = this.calcMinWidth();
        this.height1 = this.calcMinHeigh1();
        this.height2 = this.calcMinHeigh2();
        this.height3 = this.calcMinHeigh3();
    }

    public int calcMinWidth() {
        int n;
        FontMetrics fontMetrics = State.fm;
        int n2 = fontMetrics.stringWidth(this.visibilityMark() + this.typeMark() + " " + this.className);
        for (Attribute commonConst : this.attributeList) {
            if (commonConst.visibility.level() > State.attributeVisibility || (n = fontMetrics.stringWidth(commonConst.visibilityMark() + commonConst.attributeName)) <= n2) continue;
            n2 = n;
        }
        for (Method method : this.methodList) {
            if (method.visibility.level() > State.methodVisibility || (n = fontMetrics.stringWidth(method.visibilityMark() + method.methodName)) <= n2) continue;
            n2 = n;
        }
        return Util.adjust(n2 + 16);
    }

    public int calcMinHeigh1() {
        int n = State.fm.getHeight() + 2;
        return Util.adjust(n + 4);
    }

    public int calcMinHeigh2() {
        int n = 0;
        for (Attribute attribute : this.attributeList) {
            if (attribute.visibility.level() > State.attributeVisibility) continue;
            ++n;
        }
        int n2 = (State.fm.getHeight() + 2) * n;
        return Util.adjust(n2 + 4);
    }

    public int calcMinHeigh3() {
        int n = 0;
        for (Method method : this.methodList) {
            if (method.visibility.level() > State.methodVisibility) continue;
            ++n;
        }
        int n2 = (State.fm.getHeight() + 2) * n;
        return Util.adjust(n2 + 4);
    }

    public void clearUndoRedoModel() {
        this.undoredoModel = new UndoRedoModel();
    }

    public ClassNode clone() {
        try {
            return (ClassNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        ClassNode classNode = (ClassNode)object;
        if (this.classId != classNode.classId) {
            return false;
        }
        if (this.packageId != classNode.packageId) {
            return false;
        }
        if (!this.classType.equals((Object)classNode.classType)) {
            return false;
        }
        if (!this.className.equals(classNode.className)) {
            return false;
        }
        if (!this.visibility.equals((Object)classNode.visibility)) {
            return false;
        }
        if (!((Object)this.methodList).equals(classNode.methodList)) {
            return false;
        }
        if (!((Object)this.attributeList).equals(classNode.attributeList)) {
            return false;
        }
        if (this.delFlag != classNode.delFlag) {
            return false;
        }
        if (!this.p.equals(classNode.p)) {
            return false;
        }
        if (this.height1 != classNode.height1) {
            return false;
        }
        if (this.height2 != classNode.height2) {
            return false;
        }
        if (this.height3 != classNode.height3) {
            return false;
        }
        if (this.width != classNode.width) {
            return false;
        }
        if (this.colorRed != classNode.colorRed) {
            return false;
        }
        if (this.colorGreen != classNode.colorGreen) {
            return false;
        }
        return this.colorBlue == classNode.colorBlue;
    }
}

