/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import pbl2011.common.CommonConst;
import pbl2011.gui.ClassDetailEditor;
import pbl2011.gui.ClassEditorFrame;
import pbl2011.gui.ParameterEditor;
import pbl2011.gui.State;
import pbl2011.gui.SubCanvas;
import pbl2011.gui.UMLCanvas;
import pbl2011.mvc.CurrentManager;
import pbl2011.mvc.Model;

public class ClassDiagramsPanel
extends JPanel
implements CommonConst {
    UMLCanvas mainCanvas;
    Model m;
    CurrentManager cu;

    public ClassDiagramsPanel() {
    }

    public ClassDiagramsPanel(ClassEditorFrame classEditorFrame) {
        this.mainCanvas = classEditorFrame.getMainCanvas();
        this.m = this.mainCanvas.getModel();
        this.cu = this.m.getCurrentManager();
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        ParameterEditor parameterEditor = new ParameterEditor(this.m);
        ClassDetailEditor classDetailEditor = new ClassDetailEditor(this.m, parameterEditor);
        JSplitPane jSplitPane = new JSplitPane(0, classDetailEditor, parameterEditor);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(10);
        jSplitPane.setDividerLocation(Integer.MAX_VALUE);
        jSplitPane.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane2 = new JSplitPane(1, new JScrollPane(this.mainCanvas), jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerSize(10);
        jSplitPane2.setDividerLocation(Integer.MAX_VALUE);
        SubCanvas subCanvas = new SubCanvas(this.m, classEditorFrame.getSubCanvas());
        subCanvas.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane3 = new JSplitPane(1, subCanvas, jSplitPane2);
        jSplitPane3.setOneTouchExpandable(true);
        jSplitPane3.setDividerSize(10);
        jSplitPane3.setDividerLocation(305);
        this.add((Component)jSplitPane3, "Center");
    }

    public void copy() {
        this.cu.copy();
    }

    public void cut() {
        this.cu.cut();
    }

    public void paste() {
        this.cu.paste();
    }

    public void delete() {
        this.m.deleteClass();
    }

    public void selectAll() {
        this.cu.clear();
        this.cu.addCurrentClasses(this.m.getAllActiveClassData());
    }

    @Override
    public void setFont(Font font) {
        State.font = font;
        if (this.m != null) {
            this.m.changeModel();
        }
    }

    public void undo() {
        this.cu.undo();
        this.mainCanvas.draw();
    }

    public void redo() {
        this.cu.redo();
        this.mainCanvas.draw();
    }
}

