﻿

/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
  <file> Program.cs </file>
  <brief>
	An example of UlsCs
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, Dec. 2013.
  </author>
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using uls.polaris;
using AAA.BBB;

namespace UlsCsHello
{
    class Program
    {

        public void test_basic(Sample1Lex sam_lex)
        {
            sam_lex.pushInput("Hello Uls C# world\n\t\n");

            while (sam_lex.getToken() != Sample1Lex.EOI)
            {
                sam_lex.dumpTok("\t", "\n");
            }
        }

        public void test_input_file(Sample1Lex sam_lex, String filename)
        {
            int tok_id;

            sam_lex.pushFile(filename);

            while ((tok_id = sam_lex.getToken()) != Sample1Lex.EOI)
            {
                sam_lex.dumpTok("\t", "\n");
            }
        }

        static void Main(String[] args)
        {
            String ulc_path = ".\\sample1.ulc";
            String input_file;

            if (args.Length < 1)
            {
                Console.WriteLine("usage: UlsCsDump <input> [ulc_filepath]");
                return;
            }

            input_file = args[0];

            if (args.Length >= 2)
            {
                ulc_path = args[1];
            }

            Console.WriteLine(" input_filepath = {0}", input_file);
            Console.WriteLine(" ulc_path = {0}", ulc_path);

            Program tst_obj = new Program();
            Sample1Lex sam1_lex = new Sample1Lex(ulc_path);

            Console.WriteLine(" -- From String -------------------------");
            tst_obj.test_basic(sam1_lex);

            Console.WriteLine(" -- From File -------------------------");
            tst_obj.test_input_file(sam1_lex, input_file);
        }
    }
}
