/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsToolbase.h </file>
  <brief>
   This implements utility subsystem for UlsFactory Class.
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#pragma once

#include "UlsLog.h"

namespace uls {
	namespace polaris {
#define ULS_EXCLUDE_HFILES
#include "uls/uls_config.h"
#include "uls/uls_const.h"
#define ULS_DECL_BASIC_TYPES
#include "uls/uls_type.h"
#undef ULS_DECL_BASIC_TYPES
#undef ULS_EXCLUDE_HFILES

#define ULS_EXCLUDE_HFILES
#define ULS_DECL_GLOBAL_TYPES
#include "uls_all_misc.h"
#undef ULS_DECL_GLOBAL_TYPES
#undef ULS_EXCLUDE_HFILES

#define _uls_tool_type(typ) typ##_t
#define _uls_tool_ptrtype(typ) typ##_ptr_t
#define _uls_tool_type_(typ) uls_##typ##_t
#define _uls_tool_ptrtype_(typ) uls_##typ##_ptr_t

		public ref class UlsToolbase : UlsObject {
#define ULS_EXCLUDE_HFILES

		private:
#define ULS_DECL_PRIVATE_TYPE
#include "uls_all_misc.h"
#undef ULS_DECL_PRIVATE_TYPE

		protected:
#define ULS_DECL_PROTECTED_TYPE
#include "uls_all_misc.h"
#undef ULS_DECL_PROTECTED_TYPE

		public:
#define ULS_DECL_PUBLIC_TYPE
#include "uls_all_misc.h"
#undef ULS_DECL_PUBLIC_TYPE

		private:
#define ULS_DEF_PRIVATE_TYPE
#include "uls_all_misc.h"
#undef ULS_DEF_PRIVATE_TYPE

		protected:
#define ULS_DEF_PROTECTED_TYPE
#include "uls_all_misc.h"
#undef ULS_DEF_PROTECTED_TYPE

		public:
#define ULS_DEF_PUBLIC_TYPE
#include "uls_all_misc.h"
#undef ULS_DEF_PUBLIC_TYPE

		private:
			bool isFinalized, isDisposed;
			uls_mutex_struct_t dfl_lck_syserr;
			uls_mutex_struct_t dfl_lck_sysprn;
#define ULS_DEF_PRIVATE_DATA
#include "uls_all_misc.h"
#undef ULS_DEF_PRIVATE_DATA

		protected:
			UlsLog ^_log_;
#define ULS_DEF_PROTECTED_DATA
#include "uls_all_misc.h"
#undef ULS_DEF_PROTECTED_DATA

		public:
#define ULS_DEF_PUBLIC_DATA
#include "uls_all_misc.h"
#undef ULS_DEF_PUBLIC_DATA

		private:
#define ULS_DECL_PRIVATE_PROC
#include "uls_all_misc.h"
#undef ULS_DECL_PRIVATE_PROC
			// <brief>
			// 
			// </brief>
			static UlsObjectListExp ^objs_list;

		protected:
#define ULS_DECL_PROTECTED_PROC
#include "uls_all_misc.h"
#undef ULS_DECL_PROTECTED_PROC
			void uls_toolbase_lock_syserr(void);
			void uls_toolbase_unlock_syserr(void);

			void uls_toolbase_lock_sysprn(void);
			void uls_toolbase_unlock_sysprn(void);

			static UlsToolbase()
			{
				objs_list = gcnew UlsObjectListExp();
			}

		public:
			UlsToolbase();
			virtual ~UlsToolbase();
			virtual void finalizer() override;
			!UlsToolbase();

			// delegate
			_uls_def_callback_this(uls_fgetc_ascii_str, fgetch);
			_uls_def_callback_this(consume_ms_mbcs_onechar, fgetch);

			_uls_def_callback_this(fill_utf8_buf, fill_utf_rawbuf);
			_uls_def_callback_this(fill_utf16_buf, fill_utf_rawbuf);
			_uls_def_callback_this(fill_utf32_buf, fill_utf_rawbuf);

			_uls_def_callback_this(dec_utf8_buf, dec_utf_rawbuf);
			_uls_def_callback_this(dec_utf16_buf, dec_utf_rawbuf);
			_uls_def_callback_this(dec_utf32_buf, dec_utf_rawbuf);

			UlsLog ^getUlsLog()
			{
				return _log_;
			}

			uls_sysinfo_ptr_t getUlsSysprops()
			{
				return uls_sysinfo;
			}

			static void releaseUlsObjectList()
			{
				UlsObject::finalizeUlsObjectList(objs_list);
				objs_list = nullptr;
			}

#define ULS_DECL_PUBLIC_PROC
#include "uls_all_misc.h"
#undef ULS_DECL_PUBLIC_PROC

#undef ULS_EXCLUDE_HFILES
		};

	} //  End of polaris
} // End of uls
