/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsIStream.h </file>
  <brief>
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#pragma once

#include "UlsStream.h"

using namespace System;

namespace uls {
	namespace polaris {

		// <brief>
		// UlsIStream is used for reading uls-file(*.uls).
		// The base class of UlsIStream is UlsStream.
		// </brief>
		public ref class UlsIStream : UlsStream
		{
			bool isFinalized, isDisposed;
			UlsFactory::uls_istream_t ^ihdr;
			UlsTmplList ^tmpl_vars;

			void init_uls_istream(String ^filepath, UlsTmplList ^tmpls);

			static UlsObjectListExp ^objs_list;

			static UlsIStream()
			{
				objs_list = gcnew UlsObjectListExp();
			}

		public:
			// <brief>
			// UlsIStream is used as an input file of UlsLex.
			// It's an abstraction of text (program source) file or token sequence file 'uls'.
			// The parameter 'uls_tmpls' is optional.
			// In case that the file is a token sequence file and has template variables,
			//     the parameter 'uls_tmpls' is needed.
			// </brief>
			// <parm name="filepath">inputs of UlsLex</parm>
			// <parm name="uls_tmpls">A list of template variables having its values too.</parm>
			UlsIStream(String ^filepath, UlsTmplList ^tmpls);
			UlsIStream(String ^filepath);
			virtual ~UlsIStream();
			virtual void finalizer() override;
			!UlsIStream();

			void clearTmpls();
			void addTmpl(String ^tnam, String ^tval);
			String ^getTmplValue(String ^tnam);
			bool setTmplValue(String ^tnam, String ^tval);
			void dumpTmpl();
			UlsTmplList ^getTmplList();

			// <brief>
			// Close the stream (file).
			// </brief>
			void close();

			// <brief>
			// Returns just the stored 'UlsLex' object. 
			// </brief>
			UlsFactory::uls_istream_t ^getCoreHdr();

			static void releaseUlsObjectList()
			{
				UlsObject::finalizeUlsObjectList(objs_list);
				objs_list = nullptr;
			}
		};
	}
}

