/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsIStream.cpp </file>
  <brief>
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#include "Stdafx.h"
#include "UlsLex.h"
#include "UlsIStream.h"
#include "UlsUtil.h"

using namespace System;
using namespace uls::util;

namespace uls {
namespace polaris {
	//
	// UlsIStream
	//
#define ULS_CLASS_NAME UlsIStream
	void ULS_CLASS_NAME::init_uls_istream(String ^filepath, UlsTmplList ^tmpls)
	{
		str2utf8bytes_t filepath_cpp(filepath);

		if ((ihdr = uf->uls_open_istream_file(filepath_cpp.cstr)) == nullptr) {
			Console::WriteLine("Can't create in-stream!");
			return;
		}

		tmpl_vars = tmpls;
		if (tmpl_vars == nullptr) {
			tmpl_vars = gcnew UlsTmplList();
		}

		isDisposed = isFinalized = false;
#ifdef _MANAGE_ULS_OBJECTS
		addUlsObject2List(objs_list);
#endif
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME(String ^filepath, UlsTmplList ^tmpls)
		: UlsStream(true)
	{
		init_uls_istream(filepath, tmpls);
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME(String ^filepath)
		: UlsStream(true)
	{
		init_uls_istream(filepath, nullptr);
	}

	void ULS_CLASS_NAME::finalizer()
	{
		if (isFinalized) return;
		
		if (ihdr != nullptr) {
			uf->uls_destroy_istream(ihdr);
			ihdr = nullptr;
		}

		isFinalized = true;
	}

	ULS_CLASS_NAME::~ULS_CLASS_NAME()
	{
		if (isDisposed) return;

		finalizer();
#ifdef _MANAGE_ULS_OBJECTS
		delUlsObject2List(objs_list);
#endif
		if (tmpl_vars != nullptr) {
			clearTmpls();
			tmpl_vars = nullptr;
		}

		isDisposed = true;
	}

	ULS_CLASS_NAME::!ULS_CLASS_NAME()
	{
		finalizer();
	}

	void ULS_CLASS_NAME::clearTmpls()
	{
		tmpl_vars->clear();
	}

	void ULS_CLASS_NAME::addTmpl(String ^tnam, String ^tval)
	{
		tmpl_vars->add(tnam, tval);
	}

	String ^ULS_CLASS_NAME::getTmplValue(String ^tnam)
	{
		return tmpl_vars->getValue(tnam);
	}

	bool ULS_CLASS_NAME::setTmplValue(String ^tnam, String ^tval)
	{
		return tmpl_vars->setValue(tnam, tval);
	}

	void ULS_CLASS_NAME::dumpTmpl()
	{
		tmpl_vars->dump();
	}

	UlsTmplList ^ULS_CLASS_NAME::getTmplList()
	{
		return tmpl_vars;
	}

	void ULS_CLASS_NAME::close()
	{
		if (ihdr != nullptr) {
			uf->uls_destroy_istream(ihdr);
			ihdr = nullptr;
		}

		if (tmpl_vars != nullptr) {
			clearTmpls();
			tmpl_vars = nullptr;
		}

		isDisposed = isFinalized = true;
	}

	UlsFactory::uls_istream_t ^ULS_CLASS_NAME::getCoreHdr()
	{
		return ihdr;
	}

#undef ULS_CLASS_NAME

} // End of polaris
} // End of uls
