// HelloDotNet.cpp : main project file.

#include "stdafx.h"
#include "Sample1Lex.h"

using namespace System;
using namespace uls::polaris;
using namespace AAA::BBB;

namespace HelloDotNet {
	const char *progname = "UlsHelloDot";

	void test_input_string(Sample1Lex ^sam_lex, String ^line)
	{
		sam_lex->pushInput(line);

		while (sam_lex->getToken() != Sample1Lex::EOI) {
			sam_lex->dumpTok();
		}
	}

	void test_input_file(Sample1Lex ^sam_lex, String ^filename)
	{
		Console::WriteLine("Welcome to ULS/CLI!");
		Console::WriteLine("Testing ULS in C++.NET");

		sam_lex->pushFile(filename);
		sam_lex->setFileName(filename);

		while (sam_lex->getToken() != Sample1Lex::EOI) {
			Console::WriteLine("\t[{0}] {1}", sam_lex->nameOf(), sam_lex->TokStr);
		}
	}

	void usage() {
		String ^argv0 = gcnew String(progname);
		Console::WriteLine("Usage: {0} <s|f> [string|filepath]", argv0);
		Console::WriteLine("       {0} s [string]", argv0);
		Console::WriteLine("       {0} f [filepath]", argv0);
		Console::WriteLine(" For example,", argv0);
		Console::WriteLine("       {0} s", argv0);
		Console::WriteLine("       {0} \"hello world\"", argv0);
		Console::WriteLine("       {0} f", argv0);
		Console::WriteLine("       {0} f in_0_1.txt", argv0);
	}
}

int
main(array<System::String ^> ^args)
{
	using namespace HelloDotNet;
	Sample1Lex ^sample1_lex;
	String ^config_name = gcnew String("sample1.ulc");
	String ^input_file = gcnew String("in_1_1.txt");
	String ^input_line = gcnew String("c++/cli hello world\n\t\n");
	int test_mode = 0, stat = 0;

	progname = "UlsHelloDot";

	if (args->Length < 1) {
		test_mode = 0;
	}
	else {
		// args->Length >= 1
		if (args[0] == "s") {
			test_mode = 0;
			if (args->Length >= 2) {
				input_line = args[1];
			}
		}
		else if (args[0] == "f") {
			test_mode = 1;
			if (args->Length >= 2) {
				input_file = args[1];
			}
		}
		else {
			usage();
			return -1;
		}
	}

	sample1_lex = gcnew Sample1Lex(config_name);

	switch (test_mode) {
	case 0: // tokenizing string...
		test_input_string(sample1_lex, input_line);
		break;

	case 1: // tokenizing file...
		test_input_file(sample1_lex, input_file);
		break;

	default:
		break;
	}

	delete sample1_lex;

	return 0;
}
