::
::  test_uls_dev.bat: test the compiled uls library at the develpment stage.
::  Written by Stanley Hong <link2next@gmail.com>, May 2017.
::

@echo off

set HOMEDIR=%CD%
set EXIT_STAT=0

set ULS_INSTDIR=C:\Program Files\UlsWin
set ULc2CLS=ulc2class.exe
set TARGET_NAMESPACE=uls.collection

if not exist "%ULS_INSTDIR%\Bin\%ULc2CLS%" (
	echo "%ULS_INSTDIR%\Bin\%ULc2CLS%: not found!"
	goto end_1
)

set PATH=%ULS_INSTDIR%\Bin;%PATH%

cd ..\resources
set ULS_EXAMPLES_DIR=%CD%
cd "%HOMEDIR%"

set ULc2CLS=%ULc2CLS% -lcpp

echo Css3\css3.ulc --- Css3\Css3LexBasis.h
%ULc2CLS% -o Css3Toks\Css3LexBasis.h -n %TARGET_NAMESPACE%.Css3LexBasis -pCSS_ "%ULS_EXAMPLES_DIR%"\css3.ulc
echo.

echo Html5\html5.ulc --- Html5\Html5LexBasis.h
%ULc2CLS% -o Html5Toks\Html5LexBasis.h -n %TARGET_NAMESPACE%.Html5LexBasis "%ULS_EXAMPLES_DIR%"\html5.ulc
echo.

echo Mkf\mkf.ulc --- Mkf\MkfLexBasis.h
%ULc2CLS% -o MkfToks\MkfLexBasis.h -n %TARGET_NAMESPACE%.MkfLexBasis "%ULS_EXAMPLES_DIR%"\mkf.ulc
echo.

echo Shell\shell.ulc --- Shell\ShellLexBasis.h
%ULc2CLS% -d ShellToks -f ShellLexBasis -n %TARGET_NAMESPACE%.ShellLexBasis "%ULS_EXAMPLES_DIR%"\shell.ulc
echo.

echo tokseq\tokseq.uld --- tokseq\tokseq_lex.c tokseq\tokseq_lex.h
%ULc2CLS% -lc -d TokenSequence -f tokseq_lex -pTOK_ "%ULS_EXAMPLES_DIR%"\tokseq.uld
echo.

:end_1
pause
exit %EXIT_STAT%
