## チャンネルとは
チャンネルは、イメージファイルに含めるファイル（airootfs）やインストールするパッケージ、設定ファイルなどを簡単に切り替えられるように作られたAlterLinux独自の仕組みです。この仕組みによってAlterLinuxの派生OSを簡単に作成することができます。  
初期ではパッケージの切り替えしかできませんでしたが、現在は大幅に仕様が変更され、様々な変更をチャンネルごとに行うことができます。


以下は2020年4月14日現在でのチャンネルの仕様です。　　


## スクリプトにチャンネルを認識させる
スクリプトがチャンネルを認識する条件は以下のとおりです。

- `channels`内にチャンネル名のディレクトリがある
- そのディレクトリが空ではない

空のディレクトリを作成したり、別の場所に作成してもスクリプトは認識しません。  
スクリプトがチャンネルを認識したかどうかを確認するには、`./build.sh -h`で確認できます。  
ヘルプのチャンネル一覧に表示されていないチャンネルは使用できません。  


## チャンネル名について
チャンネル名は基本的には`channels`内のディレクトリ名です。  
ディレクトリ名に使用できる全ての文字はチャンネル名に利用することができますが、空白文字や全角文字を入れた場合、一部の環境で正常に動作しない可能性が有ります。  
また、チャンネル名はスクリプト内で扱う関係上、18文字以内にすることが望ましいです。（それ以上の文字数ではヘルプでチャンネル名が正常に表示されません。）   
  
もしディレクトリ名が`.add`で終了する場合、チャンネル名は`.add`の前の文字列になります。  
これは、Gitの管理から除外し、カスタマイズした独自のチャンネルを追加するためのものです。  
最終的に引数として使用できるチャンネル名は`./build -h`を実行して確認して下さい。

### チャンネル名の重複について
**チャンネル名が`.add`がついているものといないもので重複しないようにして下さい！**  
チャンネル名の重複はスクリプトでは考慮されておらず、予期せぬ動作につながる可能性があります。  
今後は、`.add`がついているものとついていないものが重複した場合、**`.add`が付いている方が優先される**ように実装する方針です。  
もし将来的にチャンネル名の重複に対応したとしても、公式チャンネルが使用できなくなることに変わりはないので、チャンネル名の重複は絶対に行わないようにしてください。  


## それぞれのチャンネルの仕様
チャンネルを構成する主要なディレクトリは`airootfs`と`packages`です。  
`airootfs`ディレクトリはパッケージをインストールし`mksquashfs`を実行する直前に`/`を上書きします。  
`packages`ディレクトリはインストールするパッケージのリストを記述したテキストファイルを格納します。  
それ以外にも場合によって使用できるファイルがいくつか有ります。  


### airootfs
このディレクトリ内を`/`としてファイルを配置して下さい。全てのファイルの権限はなるべく引き継がれるようになっています。  

### customize_airootfs.sh
各チャンネルの`airootfs`で、`/root/customize_airootfs_<チャンネル名>.sh`というファイルが配置された場合、ビルドスクリプトは、`customize_airootfs.sh`が実行された後に実行します。  
もしrootfsの設定を変更したい場合、このファイルを作成して下さい。


### packages
このディレクトリ内に配置された、ファイル名が`.x86_64`で終わるがパッケージリストとして読み込まれます。  
1行で1つのパッケージとして扱い、`#`から始まる行はコメントとして扱われます。  

パッケージ名やパッケージリストのファイル名に空白文字や全角文字を含めると正常に動作しない可能性があります。

一部、パッケージリストに記述してはいけないパッケージが有ります。  
詳細は[こちら](PACKAGE.md)を参照して下さい。  


#### 特殊なパッケージリスト
特殊なパッケージリストとして、`jp.x86_64`と`non-jp.x86_64`があります。  
`-j`オプションによって日本語が有効化されている時、スクリプトは`jp.x86_64`を読み込みます。  
反対に日本語が有効化されていない場合、スクリプトは`non-jp.x86_64`を使用します。  


#### 除外リスト
もしあなたが`share`チャンネルのパッケージでどうしてもインストールしたくないパッケージがある場合、`packages`ディレクトリ内に`exclude`というファイルを作成し、その中にパッケージを記述することでパッケージを除外することができます。  
例えば`share`で必ずインストールされる`alterlinux-calamares`をインストールしたくない場合、そのチャンネルの`exclude`にパッケージ名を追加することでインストールされなくなります。  
（その場合は各チャンネルのcustomize_airootfsで不要なファイルを削除して下さい。）  
パッケージの記述方法はパッケージリストと同様で、1行で1つのパッケージとして扱い、`#`から始まる行はコメントとして扱われます。  
  
除外できないパッケージも存在します。  
スクリプトによって強制的にインストールされるパッケージ（`efitools`など）は除外リストに関係なくインストールされます。  
  
`channels/share/packages/exclude`は、上記のスクリプトによってインストールされるパッケージの一覧が記述されています。  
これは作業ディレクトリに正確にログを記録するためです。  


### description.txt
これはチャンネルの説明を記述したテキストファイルです。`channels/<channel_name>/description.txt`に配置されます。  
このファイルは必須ではありません。このファイルが無い場合、ヘルプには`This channel does not have a description.txt.`と表示されます。  

このファイルは1行で記述することが推奨されています。複数行を記述する必要がある場合、テキストのレイアウトを考えて2行目以降は先頭に19個の半角空白文字を入れたほうが良いでしょう。  


### pacman.conf
`channels/<channel_name>/pacman.conf`を配置すると、ビルド時にそのファイルを使用します。ただし、インストール後の設定ファイルは置き換えないので`airootfs`で`/etc/pacman.conf`を配置して下さい。


### splash.png
`channels/<channel_name>/splash.png`を配置すると、SYSLINUXのブートローダの背景を変更することができます。  
PNG形式の画像で640x480の画像を配置してください。


### config
`channels/<channel_name>/config`を配置すると、既存のビルド設定を上書きすることができます。かならずシェルスクリプトの構文で記述して下さい。雛形が`build.sh`と同じ階層に設置してあります。  
この設定ファイルは**引数による設定さえ**上書きしてしまうため、最小限の必須項目のみを記述するようしてください。（例えばPlymouthのテーマ名やパッケージ名など）


## 特殊なチャンネル
### share
特殊なチャンネルとして`share`チャンネルがあります。`share`チャンネルは指定されたチャンネルに関わらず使用される共有チャンネルです。  
`share`はその他のチャンネルと同じ構造をしていますが、`share`単体をチャンネルとして指定してビルドすることはできません。  
全てのチャンネルでインストールされる基本パッケージや共通のファイルなどをここに追加します。  

`airootfs`でファイルが重複した場合、`share`のファイルは上書きされます。  
例えば`share`と`xfce`で同じ配置先のファイルがあった場合、`xfce`のファイルが使用されます。  
  
### rebuild
他にも`rebuild`チャンネルがあります。このチャンネルはヘルプには表示されていますがディレクトリの実体はありません。このチャンネルはスクリプトに組み込まれています。  
このチャンネルは作業ディレクトリに生成されたビルドオプションを保存したファイルを読み込み、再ビルドを行うチャンネルです。  
そのため作業ディレクトリが存在しない場合はエラーを出力し正常に機能しません。  
**このチャンネルはまだアルファ版です。再ビルドによって予期せぬ問題が発生する可能性が有ります。**