# 貢献する方法 -日本語-

## コーディング規約

### 全体
- なるべく`bash`のビルドインコマンドを使用する
- 外部コマンドを使用する場合は依存パッケージを追加する（極力使用しない）

### 出力
- エラーメッセージは全て`STDERR`に出力する
- メッセージ用の関数がある場合はその関数を使用する
- 最小限の出力とし、冗長な出力は引数で有効化された場合のみに許可する

### 見た目
- インデントはスペース4つとする
- 引数の多いコマンド（`xorriso`など）やパイプを多用する場合は`\`で改行する
- コードにTodoを書く場合は日付とユーザー名を書く

### 変数や関数
- 全ての関数に概要や使い方にコメントを書く
- 関数の定義は`function`を付けず、`my_func () {}`を使用する
- 全ての変数は`${hoge}`のように括弧を使用する
- 関数内でしか使用しない変数は必ず`local`で宣言する
- コマンド置き換えは`` `echo hoge` ``ではなく`$(echo hoge)`を使用する
- 算術式展開は`$(( m + n ))`を使用する

### if、for、test、case、while
- `test`コマンドは必ず`[[`を使用する
- `do`や`then`などは`while`、`for`、`if`と同じ行に書く
- `case`の際はなるべくインデントを揃える

### 例
```bash
# Usage: test_hoge <str>
test_hoge () {
    local _var="${1}"
    if [[ "${var}" = "hoge" ]]; then
        echo "${var} is hoge"
        return 0
    else
        echo "${var} is not hoge"
        return 1
    fi
}
```


### その他
- 極力相対パスを使用しない
- ファイルパスは必ず`""`で囲む

## プルリクエスト
日本語もしくは英語で内容を書いて下さい。内容とは具体的に以下のものを指します。
- どのような機能を追加するか（問題を修正するのか）
- 現在確認されている問題（その対処方法も書ければ）
- 参考にした文献について
- 動作を確認した環境や開発環境
