<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: List_success.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>
<script type="text/javascript">

var subs = new Object();
<?php
foreach ($template['subjects'] as $subject) {
?>
subs[<?= $subject->sid ?>] = {sid:'<?= $subject->sid ?>', name:'<?= $subject->name ?>', usable:'<?= $subject->usable ?>'};
<?php
}
?>

</script>
<script src="files/js/subject_list.js" type="text/javascript"></script>
</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">

	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" class="sub_b_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
}
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>

	<div id="main">
		<div id="compose2">
			
			<div id="navi">
				<h1>科目</h1>
			</div>
			
			<div class="subs_list">
				<table>
<?php
foreach ($template['subjects'] as $subject) {
?>
				<tr>
					<td id="sub_list_<?= $subject->sid ?>" class="sub_list sub_b_<?= TemplateUtils::subType($subject->sid) ?>">
						<span class="sub_list sub_b_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></span>
					</td>
					<td class="sub_list sub_b_<?= TemplateUtils::subType($subject->sid) ?>">
						<span class="sub_list_usable"><?= ($subject->usable) ? '受講可' : '受講不可' ?></span>
					</td>
					<td>
						<a href="#" onclick="editSubject('<?= $subject->sid ?>');" class="operation">編集</a>
					</td>
					<td>
						<a href="#" onclick="deleteSubject('<?= $subject->sid ?>');"><img src="files/images/delete.gif" alt="削除"></a>
					</td>
				</tr>
<?php
}
?>
				</table>
			</div>
			
			<form id="del_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Subject', 'List')) ?>" method="post">
				<input type="hidden" name="del_submit" value="true" />
				<input id="del_sid" type="hidden" name="del_sid" value="" />
			</form>
			
			<div id="sub_edit_expand" class="console" style="display:none;">
				<form id="edit_form" action="<?= htmlspecialchars(TemplateUtils::createURL('Subject', 'List')) ?>" method="post">
					<input type="hidden" name="edit_submit" value="true" />
					<input id="edit_sid" type="hidden" name="edit_sid" value="" />
					<div class="console_header">科目の編集</div>
					<table>
						<tr>
							<th>科目名</th>
							<td>
								<input id="edit_name" name="edit_name" class="input_mid" type="text" value="" size="35" maxlength="256" />
							</td>
						</tr>
						<tr>
							<th>受講</th>
							<td>
								&nbsp;
								<input id="edit_usable_1" name="edit_usable" class="input_mid" type="radio" value="1" />可
								&nbsp;
								<input id="edit_usable_0" name="edit_usable" class="input_mid" type="radio" value="0" />不可
							</td>
						</tr>
					</table>
					<a href="#" class="operation" onclick="submitEdit();">更新</a>
					| <a href="#" class="operation" onclick="undisplayEdit();">取りやめ</a>
				</form>
			</div>

			
			<div id="sub_add_collapse" class="sub_add_collapse">
				<a href="#" onclick="displayAdd();" class="operation">科目を追加</a>
			</div>
			<div id="sub_add_expand" class="console" style="display:none;">
				<form id="add_form" action="<?= TemplateUtils::createURL('Subject', 'List') ?>" method="post">
					<input type="hidden" name="add_submit" value="true" />
					<div class="console_header">科目の追加</div>
					<table>
						<tr>
							<th>科目名</th>
							<td>
								<input id="add_name" name="add_name" class="input_mid" type="text" value="" size="35" maxlength="256" />
							</td>
						</tr>
						<tr>
							<th>受講</th>
							<td>
								&nbsp;
								<input name="add_usable" class="input_mid" type="radio" value="1" checked="checked"/>可
								&nbsp;
								<input name="add_usable" class="input_mid" type="radio" value="0" />不可
							</td>
						</tr>
					</table>
					<a href="#" class="operation" onclick="submitAdd();">この科目を追加</a>
				</form>
			</div>
			<div class="div_clear">&#160;</div>
			
		</div>
		
	</div>
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
<?php
if(!count($template['subjects'])) {
?>
<script type="text/javascript">
displayAdd();
</script>
<?php
}
?>
</body>
</html>