<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: Detail_success.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
</head>
<body>
<div id="container">

<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach($template['subjects'] as $subject) {
?>
			<li class="sub_s"><a id="sub_<?= $subject->sid ?>" href="#" class="<?= ($subject->sid == $template['exam']->sid) ? '' : 'disable ' ?>sub_s_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a></li>
<?php
} 
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	<div id="main">
		<div id="navi">
			<h1><?= htmlspecialchars($template['exam']->name) ?></h1>
			&nbsp;<?= htmlspecialchars(TemplateUtils::formatDateTime($template['exam']->publish_time)) ?>配信
			&nbsp;<?= ($template['exam']->deadline_time) ? htmlspecialchars(TemplateUtils::formatDateTime($template['exam']->deadline_time)).'締切' : '締切なし' ?>
			&nbsp;全<?= $template['exam']->getQuestionsCount() ?>問
			&nbsp;<?= $template['exam']->getTotalPoint() ?>点満点
			<br />
			<a href="javascript:history.back();" class="operation">戻る</a>
		</div>
		
		<div class="result_exam_info">
			<table>
				<tr>
					<th>学年</th>
					<th>学生番号</th>
					<th>氏名</th>
					<th>受験日</th>
					<th>得点</th>
				</tr>
				<tr>
					<td><?= htmlspecialchars($template['sed']->uyear) ?></td>
					<td><?= htmlspecialchars($template['sed']->unumber) ?></td>
					<td><?= htmlspecialchars($template['sed']->uname) ?></td>
					<td><?= htmlspecialchars(TemplateUtils::formatDateTime($template['sed']->reply_date)) ?></td>
					<td><?= htmlspecialchars($template['sed']->points) ?></td>
				</tr>
			</table>
		</div>
		
		<div class="result_exam">
<?php
foreach($template['exam']->questions as $question) {
?>
			<table>
				<tr>
					<th class="vertical_top" width="5%">設問<?= $question->number ?></th>
					<td width="75%"><?= nl2br(htmlspecialchars($question->question)) ?></td>
					<td width="20%"></td>
				</tr>
				<tr>
					<th></th>
					<td>
						<ul>
<?php
	for($i = 0; $i < count($question->choices); $i++) {
?>
							<li><?= $i + 1 ?>. <?= htmlspecialchars($question->choices[$i]->value) ?></li>
<?php
	}
?>
						</ul>
					</td>
<?php
	$sqd = $template['sed']->getQuestionByNumber($question->number);
?>
					<td class="result_exam_<?= ($sqd->point) ? "right" : "check" ?>">
						配点 <?= $question->point ?><br />
						正解 <?= $question->getCorrectNumber() ?>. <?= htmlspecialchars($question->getCorrectValue()) ?><br />
						回答 <?= ($sqd && $sqd->getAnswerNumber()) ? $sqd->getAnswerNumber().". ".htmlspecialchars($sqd->getAnswer()) : '' ?>
					</td>
				</tr>
			</table>
<?php
}
?>
		</div>
	</div>
	
	
	<div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
</body>
</html>