<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: DetailAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once (OPT_DIR.'u-learning/data/StudentExamDetail.class.php');

/**
 * DetailAction
 * 
 * テスト結果詳細
 */
class DetailAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        $db= $request->getAttribute('DB');
        $admin= $request->getAttribute('admin');

        // 科目を取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        if ($request->hasParameter('rid')) {
            $rid= $request->getParameter('rid');

            // テスト結果を取得　
            $sed= new StudentExamDetail($rid, $db);
            $sed->setQuestions();
            $request->setAttribute('sed', $sed);

            // テストを取得
            $exam= new AdminExam($sed->eid, $db);
            $exam->setQuestions();
            $request->setAttribute('exam', $exam);

        }

        return VIEW_SUCCESS;
    }
}
?>