<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: HistoryAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (BASE_DIR.'modules/Exam/config/list_config.php');

/**
 * HistoryAction
 * 
 * 配信履歴
 */
class HistoryAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db = $request->getAttribute('DB');
        $admin = new Admin($user->getAttribute('aid'), $db);

        // 科目取得
        $subjects = $admin->getSubjects();
        $request->setAttribute('subjects', $subjects);

        // 配信済テストの最大数
        $max = $admin->getPubExamsCount();
        // 最大ページ数
        $max_page = ceil(($max -TOP_PUBLISHED_COUNT) / HISTORY_PUBLISHED_COUNT);
        $request->setAttribute('max_page', $max_page);

        $page = 0;
        $start = 0;
        if ($request->hasParameter('page')) {
            $page = $request->getParameter('page');
            if ($page < 1) {
                $this->location('Exam', 'List');
                return VIEW_NONE;
            }

            $start = TOP_PUBLISHED_COUNT + HISTORY_PUBLISHED_COUNT * ($page -1);
        } else {
            $page = 1;
            $start = TOP_PUBLISHED_COUNT;
        }
        $request->setAttribute('page', $page);

        $is_last = ($page == $max_page) ? true : false;
        $request->setAttribute('is_last', $is_last);

        // 配信済テスト取得
        $pubs = $admin->getPubExams($start, HISTORY_PUBLISHED_COUNT);
        $request->setAttribute('pubs', $pubs);

        return VIEW_SUCCESS;
    }

}
?>