<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: DistributeAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once (OPT_DIR.'u-learning/data/AdminQuestion.class.php');

/**
 * DistributeAction
 * 
 * テスト配信
 */
class DistributeAction extends AdminAction {

    /**
     * POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // 科目群取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        // テスト取得
        $eid= $request->getParameter('eid');
        $exam= new AdminExam($eid, $db);
        $request->setAttribute('exam', $exam);

        // テストの設問取得
        $questions= $exam->getQuestions($db);
        foreach ($questions as $key => $question) {
            // 各設問の選択肢をセットする
            $questions[$key]->setChoices($db);
        }
        $request->setAttribute('questions', $questions);

        // テストの設問数
        $request->setAttribute('questions_count', count($questions));

        // テストの合計点
        $request->setAttribute('total_point', $exam->getTotalPoint($db));

        $deadline_type= $request->getParameter('deadline_type');
        $year= $request->getParameter('date_year');
        $month= $request->getParameter('date_month');
        $day= $request->getParameter('date_day');
        $hour= $request->getParameter('time_hour');
        $min= $request->getParameter('time_min');
        $summary= $request->getParameter('summary');
        $request->setAttribute('deadline_type', $deadline_type);
        $request->setAttribute('date_year', $year);
        $request->setAttribute('date_month', $month);
        $request->setAttribute('date_day', $day);
        $request->setAttribute('time_hour', $hour);
        $request->setAttribute('time_min', $min);
        $request->setAttribute('summary', $summary);

        // すでに配信済か
        if ($exam->isPublished()) {
            return VIEW_ERROR;
        }

        // 入力後
        if ($request->getParameter('dist_input_submit')) {
            // 締切の判定
            $deadline= $exam->setDeadline($deadline_type, $year, $month, $day, $hour, $min);
            $deadline_label= $exam->getDeadlineLabel();

            $request->setAttribute('deadline', $deadline);
            $request->setAttribute('deadline_label', $deadline_label);

            // 確認画面へ
            return VIEW_ALERT;
        }

        // 確認後
        if ($request->getParameter('dist_alert_submit')) {
            // 締切の判定
            $deadline= $exam->setDeadline($deadline_type, $year, $month, $day, $hour, $min);
            $deadline_label= $exam->getDeadlineLabel();

            $request->setAttribute('deadline', $deadline);
            $request->setAttribute('deadline_label', $deadline_label);

            $exam->summary= $summary;
            // 配信
            $exam->publish();

            // 通知メールを送信
            $subject= new Subject($exam->sid, $db);
            $subject->sendPublishMail($exam, $db);

            return VIEW_SUCCESS;
        }

        return VIEW_INPUT;
    }

    /**
     * GET
     */
    function getDefaultView(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // 科目取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        // テスト取得
        $eid= $request->getParameter('eid');
        $exam= new AdminExam($eid, $db);
        $request->setAttribute('exam', $exam);

        // テストの設問取得
        $questions= $exam->getQuestions($db);
        foreach ($questions as $key => $question) {
            // 各設問の選択肢をセットする
            $questions[$key]->setChoices($db);
        }
        $request->setAttribute('questions', $questions);

        // テストの設問数
        $request->setAttribute('questions_count', count($questions));

        // テストの合計点
        $request->setAttribute('total_point', $exam->getTotalPoint($db));

        return VIEW_INPUT;
    }

    function getRequestMethods() {
        return REQ_POST;
    }

}
?>