
function selectSearchSubject() {
	var obj = getById('subject_select');
	var sub = obj.options[obj.selectedIndex].value;
	var target;
	var db;
	
	target = getById("exam_select");
	db = examdb[sub];
	setOptions(sub, target, db);
	
	target = getById("student_select");
	db = stddb[sub];
	setOptions(sub, target, db);
	
	selectSubject(obj);
}

function setOptions(sub, target, db) {
	target.length = 0;
	if (sub != "") {
		target.options[0] = new Option("", "", true, false);
		for (var i = 0; i < db.length; i++) {
			target.options[i + 1] = new Option(db[i].text, db[i].value);
		}
	} else {
		target.options[0] = new Option("科目を選択してください", "", true, false);
	}
}

function toggleResult(n) {
//	var collapse = document.getElementById('result_' + n + '_collapse');
	var expand = document.getElementById('result_' + n + '_expand');
	var trigger = document.getElementById('result_' + n + '_trigger');
	if(expand.style.display == 'none') {
		expand.style.display = 'block';
		trigger.src = 'images/collapse.gif';
//		collapse.style.display = 'none';
	}else {
		expand.style.display = 'none';
		trigger.src = 'images/expand.gif';
//		collapse.style.display = 'block';
	}
}

function searchSubmit() {
	sub = getById('subject_select');
	sid = sub.options[sub.selectedIndex].value;
	group = 'exam';
	if(getById('group_user').checked) {
		group = 'user';
	}
	exam = getById('exam_select');
	eid = exam.options[exam.selectedIndex].value;
	user = getById('student_select');
	uid = user.options[user.selectedIndex].value;
	var params = 's=' + sid + '&g=' + group + '&e=' + eid + '&u=' + uid;
	if(url.indexOf('?') > 0) {
		location.href = url + '&' + params;
	} else {
		location.href = url + '?' + params;
	}
}

function changeGroup(group) {
	if(group == 'exam') {
		changeDisplay('exam_header','none');
		changeDisplay('exam_select','none');
		changeDisplay('student_header', 'block');
		changeDisplay('student_select', 'block');
		getById('exam_select').selectedIndex = 0;
	} else if (group == 'user') {
		changeDisplay('exam_header','block');
		changeDisplay('exam_select','block');
		changeDisplay('student_header', 'none');
		changeDisplay('student_select', 'none');
		getById('student_select').selectedIndex = 0;
	}
}

function listUp(group) {
	var sub = getById('subject_select');
	sid = sub.options[sub.selectedIndex].value;
	var params = 's=' + sid + '&g=' + group;
	if(url.indexOf('?') > 0) {
		location.href = url + '&' + params;
	} else {
		location.href = url + '?' + params;
	}
}

function setSelected(sid, group, eid, uid) {
	var obj = getById('subject_select');
	for(var i = 0; i < obj.options.length; i++) {
		if(obj.options[i].value == sid) {
			obj.options[i].selected = true;
			break;
		}
	}
	selectSearchSubject();
	
	changeGroup(group);
	var list;
	if(group == 'exam') {
		getById('group_exam').checked = true;
		getById('group_user').checked = false;
		list = getById('student_select');
		for(var i = 0; i < list.options.length; i++) {
			if(list.options[i].value == uid) {
				list.options[i].selected = true;
				break;
			}
		}
	} else if (group == 'user') {
		getById('group_exam').checked = false;
		getById('group_user').checked = true;
		list = getById('exam_select');
		for(var i = 0; i < list.options.length; i++) {
			if(list.options[i].value == eid) {
				list.options[i].selected = true;
				break;
			}
		}
	}
}
