<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: InputAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//


/** 
*	InputAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');
require_once(OPT_DIR.'u-learning/data/Student.class.php');
require_once(OPT_DIR.'u-learning/data/SubjectStudent.class.php');

/** 
*	InputAction
*/
class InputAction extends SecureStudentAction {
    function execute (&$controller, &$request, &$user) {

		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		$uid = $user->getAttribute('uid');
		$aid = $user->getAttribute('aid');

		// 擾
		$request->setAttribute('admin', new Admin($aid, $DB));
		
		// Ȗڂ擾
    	$admin = new Admin($user->getAttribute('aid'), $DB);
    	$subjects = $admin->getUsableSubjects($DB);
		// w擾
		$student = new Student($aid, $uid, $DB);
    	$subjects_user = $student->getSubjectStudent($DB);
		
		if($request->getParameter('edit') ) {
			// [UύX
			$pass = $request->getParameter('pass');
			$pass_new = $request->getParameter('pass_new');
			$pass_new2 = $request->getParameter('pass_new2');
			$mail = $request->getParameter('mail');
			$mail_old = $request->getParameter('mail_old');
			$name = $request->getParameter('name');
			$number = $request->getParameter('number');
			$year = $request->getParameter('year');
			
			$subjects_user_new = $request->getParameter('subject');

			// ̓`FbN
			$error = "";
			$pass_info = false;
			// pX[h
			if(trim($pass) != '' || trim($pass_new) != '' || trim($pass_new2) != '') {
				if($student->pass != $pass) {
					$error .= "݂̃pX[hႢ܂B\n";
			    	$request->setAttribute('student', $student);
				}
				if($pass_new != $pass_new2) {
					$error .= "mFp̃pX[hقȂĂ܂B\n";
			    	$request->setAttribute('student', $student);
				}
				if ( !(ereg("[0-9]+", $pass_new)) || strlen($pass_new) > 6 || strlen($pass_new) < 4){
					$error .= "pX[h46܂ł̐ɂĂB \n";
				}
				// G[ȂpX[hύX
				if($error == ""){
					$student->pass = $pass_new;
					$pass_info = true;
				}
			}
			if( trim($mail) == '' || trim($name) =='' || trim($number) == '' || trim($year) == ''){	
				$error .= "l͑Sē͂ĂB \n";
			}			
			if (!ereg(".+@.+\..+", $mail) ){
				$error .= "[AhXsłB \n";			
			}
	
			$student->mail = $mail;
			$student->name = $name;
			$student->number = $number;
			$student->year = $year;
			// G[ȂXV
			if($error == ""){
				$student->update($DB);
				// ȖڍXV
				
				$subject_user = new SubjectStudent();
				$subject_user->aid = $aid;
				$subject_user->uid = $uid;
				$subject_user->deleteSubject($DB);
				
				foreach ($subjects_user_new as $sid) {
					$subject_user->sid = $sid;
					$subject_user->insert($DB);
												
				}				
				
				// [AhXύX̓[
				if($mail != $mail_old){

					mb_internal_encoding('SJIS');
					
					$from = $aid;        //from
					$subject = "[U[jO]AhXύX";  //TuWFNg
					$message = "̃[AhX͑MpłB\nԐM͂ł܂B\n\n";
					$message .= "[AhXύX܂B\n\n";

					// wb_
					$head  = "From: $from".MAIL_DOMAIN."\n";		//From
					$head .= "X-Mailer: PHP/".phpversion()."\n";
					$head .= "MIME-version: 1.0\n";	//MIMEwb_
					$head .= "Content-Type: text/plain; charset=iso-2022-jp\n";
					$head .= "Content-Transfer-Encoding: 7bit\n";
					
					// {
					$body = $name."\n\n".$message;
					
					mb_send_mail($mail, $subject, $body, $head);				
				
				}
				
				$request->setAttribute('student', $student);
				$request->setAttribute('mail_old', $mail_old);
				$request->setAttribute('pass_info', $pass_info);
				return VIEW_SUCCESS;

			}
			
			$request->setAttribute('error', $error);
			$request->setAttribute('student', $student);
			$request->setAttribute('mail_old', $mail_old);
			$request->setAttribute('pass', $pass);
			$request->setAttribute('pass_new', $pass_new);
			$request->setAttribute('pass_new2', $pass_new2);
			$request->setAttribute('subjects', $subjects);
			$request->setAttribute('subjects_user', $subjects_user_new);

			return VIEW_ERROR;

		}
		if($request->getParameter('back') ) {
			$this->location('Top', 'Index');
			return VIEW_NONE;
		}	
		$request->setAttribute('student', $student);
		$request->setAttribute('subjects', $subjects);
		$request->setAttribute('subjects_user', $subjects_user);
		return VIEW_INPUT;
    }
	
	
}

?>