<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: History_success.php,v 1.1 2005/06/20 09:31:25 snapshot Exp $
//
// Description:
// 2005/05/18
//
include(BASE_DIR."templates/header.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Uラーニング</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="files/css/main.css" type="text/css" />
<script src="files/js/main.js" type="text/javascript"></script>
<script src="files/js/dom.js" type="text/javascript"></script>

</head>
<body>
<div id="container">


<div id="header">
	<div class="menu">
		<div class="menu_right">
			<table>
				<tr>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('User','List')) ?>">学生管理</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Subject','List')) ?>">科目編集</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Config','Input')) ?>">設定</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Login','Logout')) ?>">ログアウト</a></td>
				</tr>
			</table>
		</div>
        <div class="menu_login">
            ログイン : <?= htmlspecialchars($template['admin']->aid) ?>
        </div>
		<div class="menu_left">
			<table>
				<tr>
					<td class="menu_focus"><a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','List')) ?>">テスト</a></td>
					<td><a href="<?= htmlspecialchars(TemplateUtils::createLink('Results','Search')) ?>">成績</a></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="div_clear"></div>
</div>


<div id="contents">
	
	<div id="subject">
		<ul>
<?php
foreach ($template['subjects'] as $subject) {
?>
			<li class="sub_s">
				<a id="sub_<?= $subject->sid ?>" href="javascript:toggleSubject(<?= $subject->sid ?>);" class="sub_b_<?= TemplateUtils::subType($subject->sid) ?>"><?= htmlspecialchars($subject->name) ?></a>
			</li>
<?php
}
?>
		</ul>
		<div class="div_clear">&#160;</div>
	</div>
	
	
	<div id="main">

		<div id="list_processed">
			<div id="navi2">
				<h1>配信済のテスト</h1>
			</div>
			
			<ul>
<?php
foreach ($template['pubs'] as $exam) {
?>
				<li class="sub_<?= $exam->sid ?>">
					<span class="subject sub_c_<?= TemplateUtils::subType($exam->sid) ?>"><?= htmlspecialchars($exam->sname) ?></span>
					&nbsp;
					<span>
						<a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','Questions', array('eid'=>$exam->eid))) ?>" class="processed"><?= htmlspecialchars($exam->name) ?></a>
					</span>
					&nbsp;
					<span>―<?= htmlspecialchars(TemplateUtils::formatDateTime($exam->publish_time)) ?></span>
				</li>
<?php
}
?>
			</ul>
            <div class="text_center">
                <?= $template['page']+1 ?> / <?= $template['max_page']+1 ?>
            </div>
<?php
if(!$template['is_last']) {
?>
            <div class="div_right">
                <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','History', array('page'=>$template['page']+1))) ?>" class="operation">もっと前の配信 &gt;&gt;</a>
            </div>
<?php
}
?>
            <div>
                <a href="<?= htmlspecialchars(TemplateUtils::createLink('Exam','History', array('page'=>$template['page']-1))) ?>" class="operation">&lt;&lt; もっと後の配信</a>
            </div>
		</div>
	</div>
    <div class="div_clear">&#160;</div>
</div>


<?php
include(BASE_DIR.'templates/admin_footer.php');
?>

<div class="div_clear">&nbsp;</div>


</div>
</body>
</html>