<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: StudentExam.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');

/**
 * StudentExam
 * 
 * 学生テスト回答クラス
 */
class StudentExam extends DataObject {

    // 回答ID;
    var $rid;

    // 教員ID
    var $aid;
    // 学生ID
    var $uid;
    // テストID
    var $eid;

    // 回答日
    var $reply_date;
    // 合計点
    var $points;

    // 学生設問解答
    var $questions;

    /**
     * コンストラクタ
     */
    function StudentExam($rid= null, $db= null) {
        if (!is_null($rid) && !is_null($db)) {
            $this->setDB($db);
            $this->rid= $rid;

            $sql= "SELECT * FROM user_exam WHERE rid = $rid";
            $row= $this->DB->GetRow($sql);
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }
    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->rid= $array['rid'];
        $this->eid= $array['eid'];
        $this->reply_date= $array['reply_date'];
        $this->points= $array['points'];
    }

    /**
     * 配列から値をセットする
     */
    function setExamValues($array) {
        $this->setValues($array);
    }

    /**
     * 回答情報登録
     */
    function insert($db= null) {
        $this->setDB($db);
        $sql= "insert into user_exam (aid, uid, eid) values (".$this->DB->qstr($this->aid).", ".$this->DB->qstr($this->uid).", ".$this->eid.")";
        return $this->DB->Execute($sql);

    }

    /**
     * 回答情報更新(更新日以外)
     */
    function updateWithoutReplyDate($db= null) {
        $this->setDB($db);
        $sql= "update user_exam set "."aid = ".$this->DB->qstr($this->aid).", "."uid = ".$this->DB->qstr($this->uid).", "."eid = ".$this->eid.", "."points = ".$this->points." "."where rid = ".$this->rid;
        return $this->DB->Execute($sql);

    }

    /**
     * 回答情報更新(更新日含む)
     */
    function update($db= null) {
        $this->setDB($db);
        $sql= "update user_exam set "."aid = ".$this->DB->qstr($this->aid).", "."uid = ".$this->DB->qstr($this->uid).", "."eid = ".$this->eid.", "."reply_date = ".$this->DB->qstr($this->reply_date).", "."points = ".$this->points." "."where rid = ".$this->rid;
        return $this->DB->Execute($sql);

    }

    /**
     * 未回答のID取得
     */
    function getUnansweredID($db= null) {
        $this->setDB($db);
        $sql= "select rid from user_exam where reply_date is null and aid = ".$this->DB->qstr($this->aid)." and uid = ".$this->DB->qstr($this->uid)." and eid = ".$this->eid."";
        return $this->DB->GetOne($sql);
    }

    /**
     * 現在の得点をセット
     */
    function setPoints($db= null) {
        $this->setDB($db);
        $sql= "select sum(point) as points from user_question where rid = ".$this->rid;
        $this->points= $this->DB->GetOne($sql);
        if(is_null($this->points) || $this->points == ''){
        	$this->points = 0;
        }
        return $this->points;
    }

}
?>