<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: AdminChoice.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/19
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');

/**
 * AdminChoice
 * 
 * 設問選択肢クラス
 */
class AdminChoice extends DataObject {

    // 選択肢ID
    var $cid;

    // テストID
    var $eid;
    // 設問ID
    var $qid;
    // 選択肢内容
    var $value;
    // 正解フラグ
    var $correct;

    function AdminChoice($cid = null, $db = null) {
        if (!is_null($cid) && !is_null($db)) {
            $this->setDB($db);
            $sql = "SELECT * FROM admin_choice WHERE cid = ".$this->DB->qstr($cid);
            $row = $this->DB->GetRow($sql);
            $this->setValues($row);
        }
    }

    /**
     * 配列に含まれているプロパティをセットする
     */
    function setValues($array) {
        $this->cid = $array['cid'];
        $this->eid = $array['eid'];
        $this->qid = $array['qid'];
        $this->value = $array['value'];
        $this->correct = $array['correct'];
    }

    /**
     * 自分自身をDBへ追加
     */
    function insert($db = null) {
        $this->setDB($db);
        $sql = "INSERT INTO admin_choice (eid, qid, value, correct) "."VALUES (".$this->eid.", ".$this->qid.", ".$this->DB->qstr($this->value).", ".$this->DB->qstr($this->correct).")";
        return $this->DB->Execute($sql);
    }

    /**
     * DBを更新
     */
    function update($db = null) {
        $this->setDB($db);
        $sql = "UPDATE admin_choice SET "."eid = ".$this->eid.", "."qid = ".$this->qid.", "."value = ".$this->DB->qstr($this->value).", "."correct = ".$this->DB->qstr($this->correct)." WHERE cid = ".$this->cid;
        return $this->DB->Execute($sql);
    }

}
?>