
function toggleSubject(sid) {
	var subLabel = document.getElementById('sub_' + sid);
	var subElements = getElementsByClassName('sub_' + sid);
	var regex = /disable\s(.*)/;
	if(subLabel.className.match(regex)) {
		subLabel.className = RegExp.$1;
		for(var i = 0; i < subElements.length; i++) {
			subElements[i].style.display = 'block';
		}
	}else {
		subLabel.className = 'disable ' + subLabel.className;
		for(var i = 0; i < subElements.length; i++) {
			subElements[i].style.display = 'none';
		}
	}
}



function changeCategory(catId) {
	var catLabel = document.getElementById('cat_' + catId);
	var allA = document.getElementsByTagName('a');
	var regex = /^cat_(.*)/;
	for(var i = 0; i < allA.length; i++) {
		if(allA[i].id.match(regex)) {
			if(allA[i].id == 'cat_' + catId) {
				allA[i].className = 'cat_s_' + catId;
			}else {
				allA[i].className = 'disable ' + allA[i].className;
			}
		}
	}
	
}

function changeSubject(subId) {
	var subLabel = document.getElementById('sub_' + subId);
	var allA = document.getElementsByTagName('a');
	var regex = new RegExp("(sub_.*)");
	for(var i = 0; i < allA.length; i++) {
		if(allA[i].id.match(regex)) {
			allA[i].className.match(regex);
			if(allA[i].id == 'sub_' + subId) {
				allA[i].className = RegExp.$1;
			}else {
				allA[i].className = "disable " + RegExp.$1;
			}
		}
	}
	
}

function selectCategory(obj) {
	var selected;
	for(var i = 0; i < obj.options.length; i++) {
		if(obj.options[i].selected) {
			selected = obj.options[i];
			break;
		}
	}
	changeCategory(selected.value);
}

function selectSubject(obj) {
	var selected = obj.options[obj.selectedIndex];
/*
	for(var i = 0; i < obj.options.length; i++) {
		if(obj.options[i].selected) {
			selected = obj.options[i];
			break;
		}
	}
*/
	changeSubject(selected.value);
}

function toggleCat(n) {
	var collapse = document.getElementById('cat_' + n + '_collapse');
	var expand = document.getElementById('cat_' + n + '_expand');
	if(expand.style.display == 'none') {
		expand.style.display = 'block';
		collapse.style.display = 'none';
	}else {
		expand.style.display = 'none';
		collapse.style.display = 'block';
	}
	
	
}




/* Yellow fade technique */
var yfElements;
var yfColor= new Array();
yfColor[1] = "ff";
yfColor[2] = "ee";
yfColor[3] = "dd";
yfColor[4] = "cc";
yfColor[5] = "bb";
yfColor[6] = "aa";
yfColor[7] = "99";

function readyToFade() {
	yfElements = getElementsByClassName('fade');
	if(yfElements) {
		setTimeout("yellowFade(7)", 0);
	}
}

function yellowFade(key) {
//	alert(yfColor[key]);
	if(key < 1) return;
	for(var i = 0; i < yfElements.length; i++) {
		yfElements[i].style.backgroundColor = "#ffff" + yfColor[key];
		
	}
	if (key > 1) {
		key -= 1;
		setTimeout("yellowFade("+key+")", 100);
	} else {
		key -= 1;
	
		for(var i = 0; i < yfElements.length; i++) {
			yfElements[i].style.backgroundColor = "white";
			yfElements[i].className = yfElements[i].className.replace(/fade[\s]*/, '');
		}
	}
	
	
}

function sanitize(value) {
	if(!value) return value;
	var reg;
	reg = new RegExp('&', 'gm');
	value = value.replace(reg, '&amp;');
	reg = new RegExp('<', 'gm');
	value = value.replace(reg, '&lt;');
	reg = new RegExp('>', 'gm');
	value = value.replace(reg, '&gt;');
	reg = new RegExp('"', 'gm');
	value = value.replace(reg, '&quot;');
	reg = new RegExp("'", 'gm');
	value = value.replace(reg, '&#39;');
	return value;
}

function desanitize(value) {
	if(!value) return value;
	var reg;
	reg = new RegExp('&amp;', 'gm');
	value = value.replace(reg, '&');
	reg = new RegExp('&lt;', 'gm');
	value = value.replace(reg, '<');
	reg = new RegExp('&gt;', 'gm');
	value = value.replace(reg, '>');
	reg = new RegExp('&quot;', 'gm');
	value = value.replace(reg, '"');
	reg = new RegExp('&#39;', 'gm');
	value = value.replace(reg, "'");
	return value;
}
