
include Java
require 'kconv'
require 'txpftpcallback'

#
# To change this template, choose Tools | Templates
# and open the template in the editor.

class TxpFtpShell

#-----------------------------------------------------------------------------
# constructor
#-----------------------------------------------------------------------------

    def initialize( host = nil )

        # Ȍ
        begin
        include_class 'org.apache.log4j.Logger'
        include_class 'org.apache.log4j.xml.DOMConfigurator'
        rescue => e
            puts "Error : environment must be broken."
            puts "\t" + e.to_s
        end

        org.apache.log4j.xml.DOMConfigurator::configure( "./txpftplog.xml" );
        @logger = org.apache.log4j.Logger::getLogger( "txpFTP" )

        INFO "txpFTP", "txpFTPN܂."

        # load ftp & txf classes
        begin
        include_class 'org.apache.log4j.Logger'
        include_class 'org.apache.log4j.xml.DOMConfigurator'
        include_class 'org.apache.commons.net.ftp.FTP'
        include_class 'org.apache.commons.net.ftp.FTPClient'
        include_class 'org.apache.commons.net.ftp.FTPFile'
        include_class 'org.opentxp.txf.TxFileTransaction'
        include_class 'org.opentxp.txf.TxFile'
        include_class 'org.opentxp.txf.TxFileInputStream'
        include_class 'org.opentxp.txf.TxFileOutputStream'
        rescue => e
            puts "Error : environment must be broken."
            puts "\t" + e.to_s
#TODO            puts "\tconfirm jar-files copied to $JRUBY_HOME/lib"
        end

        fCanTran = org.opentxp.txf.TxFileTransaction::canTransaction
        if false == fCanTran then
            @@sys_ltransFlag = false
            puts "Warning : This system does not support Transactional NTFS."
            WARNING "txpFTP", "This system does not support Transactional NTFS."
        else
            @@sys_ltransFlag = true
        end

        # initialize member variables
        @defaultServerName = "127.0.0.1"
        if nil != host then
            @defaultServerName = host
        end
        @serverName = host
        @defaultPortNo = nil
        # Apache FtpServer = "UTF-8", Windows FTP Server = "Shift_JIS",  Unix/Linux = "EUC-JP", etc
        # TODO ݒ艻
        @serverEncoding = "UTF-8"
        @quit = false
        @con = FTPClient.new
        @type = "ascii"
        @bell = false
        @verbosing = false
        @interactive = true
        @debugging = false
        @globbing = true
        @hashMarkPrinting = false
        @sizeOfHashMarkPrint = 2048
        @packetTracing = false
        @passiveMode = false
        @userName = ""
        @anonymous = false
        @eventListener = ProtocolCommandListenerImpl.new self
        @logdir = "./log"

        dirF = java.io.File.new "."
        if true == dirF.isDirectory then
            @localDirectory = dirF.canonical_path
        else
            @localDirectory = Dir.pwd
        end
        #TODO fBNg,[JfBNgNOTIFY

        @console = java.lang.System.console
        @userName = ""

        @con.addProtocolCommandListener @eventListener

        @con.getBufferSize

        @ltransFlag = @@sys_ltransFlag
        ltxbegin

    end

#-----------------------------------------------------------------------------
# accessors
#-----------------------------------------------------------------------------

    attr_accessor   :defaultServerName
    attr_accessor   :serverName
    attr_accessor   :verbosing
    attr_accessor   :interactive
    attr_accessor   :passiveMode
    attr_accessor   :debugging
    attr_accessor   :globbing
    attr_accessor   :anonymous
    attr_accessor   :logdir

#-----------------------------------------------------------------------------
# methods
#-----------------------------------------------------------------------------

    #
    #print Error
    #
    def ERROR cmd, message
        @logger.error "#{Process.pid} #{cmd.ljust(16)} #{message.toutf8}"
    end

    #
    #print Warning
    #
    def WARNING cmd, message
        @logger.warn "#{Process.pid} #{cmd.ljust(16)} #{message.toutf8}"
    end

    #
    #print Notification
    #
    def NOTIFY cmd, message
        @logger.info "#{Process.pid} #{cmd.ljust(16)} #{message.toutf8}"
    end

    #
    #print Infomation
    #
    def INFO cmd, message
        @logger.debug "#{Process.pid} #{cmd.ljust(16)} #{message.toutf8}"
    end

    #
    #printLog
    #
    def TRACE cmd, message
        @logger.trace "#{Process.pid} #{cmd.ljust(16)} #{message.toutf8}"
    end

    #
    #readLine
    #
    protected
    def readLine strPrompt, fHistory, fReplacePathChar = true
        java.lang.System.out.print strPrompt.toutf8
        line = @console.readLine
        if nil != line && "" != line then
            line = java.lang.String.new line
            if true == fReplacePathChar then
                line = line.replace "\\", "/"
            else
                line = line.toString
            end
            line = Kconv.kconv line, Kconv::SJIS, Kconv::UTF8
        end
        return line
    end

    #
    #readPassword
    #
    protected
    def readPassword strPrompt
        print strPrompt
        jachPassword = @console.readPassword
        if nil == jachPassword  then
            password = nil
        else
            jstrPassword = java.lang.String.new jachPassword
            password = jstrPassword.toString
        end
        return password
    end

    #
    #readAnswer
    #
    protected
    def readAnswer( prompt_line, answers, before_answer )

        if false == @interactive
            puts "#{prompt_line}"
            return "y"
        elsif "a" == before_answer
            puts "#{prompt_line}"
            return "a"
        end

        prompt_tmp = "#{prompt_line} [#{answers}?]? "
        ans = ""
        while "" == ans do

            ans = readLine prompt_tmp, true, false
            if 1 != ans.length
                ans = ""
            end
            if nil == answers.index( ans ) then
                ans = ""
            end
        end

        if "p" == ans
            @interactive = false
            ans = "y"
        end

        return ans

    end

    #
    #getLocalPathName
    #
    protected
    def getLocalPathName( localFileName )
        if  "." == localFileName[0, 1] ||
            "\\" == localFileName[0, 1] ||
            "/" == localFileName[0, 1] ||
            ":" == localFileName[1, 1] then
            pathName = localFileName
        else
            pathName = "#{@localDirectory}#{java.io.File.separator}#{localFileName}"
        end
        return pathName
    end

    def checkLocalDirectory  dirF
        if false == dirF.exists then
            puts "#{dirF.canonical_path} is not exist."
            raise ArgumentError
        elsif false == dirF.isDirectory then
            puts "#{dirF.canonical_path} is not a directory."
            raise ArgumentError
        elsif false == dirF.canRead then
            puts "#{dirF.canonical_path} is not readable."
            raise ArgumentError
        end
    end

    #
    #checkConnection
    #
    protected
    def checkConnection command

        if false == @con.isConnected then
            puts "Not connected."
            WARNING command, "ڑĂ܂"
            raise FtpError.new command, "Not connected."
        end

        return true

    end

    #
    #closeConnectionWhenError
    #
    protected
    def closeConnectionWhenError
        begin
            @con.disconnect
        rescue =>e
        end
    end

    #
    #onFtpError
    #   command : String : Ftp interpret command name
    #   e : NativeException
    #
    protected
    def onFtpError( command, e )
        ce = e.cause
        msg = ce.getMessage
        puts msg
        ERROR command, "FTPڑG[ƂȂ܂ G[(#{msg})"
        raise FtpError.new command, msg, e.cause
    end

    #
    #printHelpList
    #
    protected
    def printHelpList
        puts "Commands may be abbreviated.  Commands are:"
        @@help_description.keys.each { |key| print "#{key}".ljust(16) }
        print "\n"
    end

    #
    #print Description and beep if nessesary
    #
    protected
    def printDescription( command )
        description = @@help_description[ command ]
        if nil == description then
            printHelpList
        else
            puts description
            ringABell
        end
    end

    #
    #print Usage and beep if nessesary
    #
    def printUsage( command )
        usage = @@usage_description[ command ]
        if nil == usage then
            printHelpList
        else
            puts "Usage : #{command} #{usage}"
            ringABell
        end
    end

    #
    #print Usage and beep if nessesary
    #
    def doUsage( command )
        usage = @@usage_description[ command ]
        if nil == usage then
            raise NameError
        else
            puts "Usage : #{command} #{usage}"
            ringABell
            raise ArgumentError
        end
    end

    #
    #ringABell
    #
    protected
    def ringABell()
        if true == @bell then
            print "\a" # ring a bell
        end
    end

    #
    #print FTP statistic infomation and beep if nessesary
    #
    protected
    def printFtpStatistics()
# 0.1.0ł͉\Ȃ悤ɂĂ
#        puts "txpFTP XX bytes received. X.XX seconds XX.XX KB/sec"
#        if true == @bell then
#            print "\a" # ring a bell
#        end
    end

    #
    #getModeString
    #
    protected
    def getModeString mode
        if true == mode then
            modeString ="On"
        else
            modeString ="Off"
        end
        return modeString
    end

    #
    #print mode [On/Off]
    #
    protected
    def printMode( modeName, mode )
        modeString = getModeString mode
        puts modeName + " " + modeString + "."
    end

    #
    #print hash mark print setting
    #
    protected
    def printHashMarkPrinting
        mode = !@hashMarkPrinting
        if true == mode then
        puts "Hash mark printing On" +
            "  ftp: (" + @sizeOfHashMarkPrint.to_s + " bytes/hash mark)."
        else
        puts "Hash mark printing Off."
        end
    end

#-----------------------------------------------------------------------------
# FTP interpreter command
#-----------------------------------------------------------------------------

    #interpret
    public
    def interpret

        while @quit == false
            begin
                line = readLine "txpFTP> ", true
                if  nil == line  || "" == line then
                    if nil == line then puts "" end
                    next
                end
                args = Shellwords.shellwords( line )

                cmd = args.shift
                if cmd == "!" then
                    java.lang.Runtime.getRuntime.exec "cmd.exe /k start"
                    NOTIFY "!", "VFN܂"
                elsif cmd == "?" then
                    help
                elsif cmd == "/" || cmd == "//" then
                    puts "Invalid command."
                else

                    line = cmd
                    #TODO aliasɕύXquote͊O
                    if cmd == "quote" || cmd == "literal" || cmd == "site" then
                        line += "\'"
                        args.each { |str| line += "#{str} " }
                        line += "\'"
                    else
                        line += " "
                        args.each { |str| line += "\'#{str}\'," }
                        line.chop! if line[line.length-1, line.length] == ","
                    end


                    begin
                        ret = instance_eval( line )
                    rescue FtpError => e
                        #nop
                    rescue NameError => e
                        #TODO Oo
                        puts e
                        puts "Invalid command."
                    rescue ArgumentError => e
                        #TODO Oo
                        puts "Invalid parameters."
                    rescue SyntaxError => e
                        #TODO Oo
                        puts e
                        puts "Invalid command."
                    rescue => e
                        #TODO Oo
                        puts e
                    end
                end

            end

        end

    end

#-----------------------------------------------------------------------------
# FTP interpreter command
#-----------------------------------------------------------------------------

    #
    #Append to a file
    #
    public
    def append( localFileName = nil , remoteFileName = nil )

        methodName = "append"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        if  nil == localFileName then
            localFileName = readLine( "Local file ", true )
            if nil == localFileName || "" == localFileName then
                doUsage methodName
            end
        end
        if  nil == remoteFileName then
            remoteFileName = localFileName
        end

        begin

            pathName = getLocalPathName( localFileName )
            file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
            inputStream = org.opentxp.txf.TxFileInputStream.new file
            @con.appendFile remoteFileName.toutf8, inputStream
            printFtpStatistics

            NOTIFY methodName, "[gt@C(#{remoteFileName})Ƀ[Jt@C(#{localFileName}ǉM܂"

        #TODO fileException
        rescue NativeException => e
            onFtpError methodName, e
        ensure
            if nil != inputStream then
                inputStream.close
                inputStream = nil
            end
        end

    end

    #
    #Set ascii transfer type
    #
    public
    def ascii()

        methodName = "ascii"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            typebak = @type
            @con.setFileType( FTP::ASCII_FILE_TYPE )
            @type = "ascii"

            INFO methodName, "t@C][heLXgɐݒ肵܂"

        rescue NativeException => e
            onFtpError methodName, e
            @type = typebak
        end

    end

    #
    #Beep when command completed
    #
    public
    def bell()

        methodName = "bell"
        TRACE methodName, "R}hs܂"

        @bell = !@bell
        printMode "Bell mode", @bell

        INFO methodName, "ʒmx[h#{@bell}ɐݒ肵܂"

    end

    #
    #Set binary transfer type
    #
    public
    def binary()

        methodName = "binary"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            typebak = @type
            @con.setFileType( FTP::IMAGE_FILE_TYPE )
            @type = "binary"

            INFO methodName, "t@C][hoCiɐݒ肵܂"

        rescue NativeException => e
            onFtpError methodName, e
            @type = typebak
        end

    end

    #
    #Terminate ftp session and exit
    #
    public
    def bye()
        quit()
    end

    #
    #Change remote working directory
    #
    public
    def cd( dirName = nil )

        methodName = "cd"
        TRACE methodName, "R}hs܂ dirName=#{dirName}"

        checkConnection methodName

        if  nil == dirName then
            dirName = readLine "Remote directory ", true
            if nil == dirName || "" == dirName then
                doUsage methodName
            end
        end

        begin

            ret = @con.changeWorkingDirectory( dirName.toutf8 )

            NOTIFY methodName, "[gfBNgi#{dirName}jɕύX܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Change remote working directory to the parent
    #
    public
    def cdup()

        methodName = "cdup"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            ret = @con.changeToParentDirectory()

            NOTIFY methodName, "[gfBNgefBNgɕύX܂"
            #TODO fBNg̕\́H

        rescue NativeException => e
            onFtpError methodName, e
        end


    end

    #
    #Terminate ftp session
    #
    public
    def close()

        methodName = "close"
        TRACE methodName, "R}hs܂"

        begin

            if true == @con.isConnected then
                @con.quit
                disconnect()
            end

            NOTIFY methodName, "FTPڑN[Y܂"
            #TODO ڑ擙\Ȃ̂H

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Commit transaction
    #
    public
    def commit()

        methodName = "commit"
        TRACE methodName, "R}hs܂"

        if @trans == org.opentxp.txf.TxFileTransaction.NULL_TRANSACTION then
            puts "Warning : Current local transaction is NULL_TRANSACTION."
            return
        end
        @trans.commit
        puts "commit local transaction, id = \{#{@trans.getTransactionId}\}."

        NOTIFY methodName, "[JgUNV(#{@trans.getTransactionId})R~bg܂"

        ltxbegin

        TRACE methodName, "R}h܂"

    end

    #
    #Delete remote file
    #
    public
    def delete( remoteFileName = nil )

        methodName = "delete"
        TRACE methodName, "R}hs܂ remoteFileName=#{remoteFileName}"

        checkConnection methodName

        begin

            if  nil == remoteFileName then
                remoteFileName = readLine( "Remote file ", true )
                if nil == remoteFileName || "" == remoteFileName then
                    doUsage methodName
                end
            end
            ret = @con.deleteFile( remoteFileName.toutf8 )

            NOTIFY methodName, "[gt@C(#{remoteFileName})폜܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Toggle debugging mode
    #
    public
    def debug

        methodName = "debug"
        TRACE methodName, "R}hs܂"

        @debugging = !@debugging
        printMode "Debugging", @debugging

        INFO methodName, "fobO[h#{@debugging}ɐݒ肵܂"

    end

    #
    #List contents of remote directory
    #
    public
    def dir( remoteFileNames = nil, localFileName = nil )

        methodName = "dir"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}, localFileName=#{localFileName}"

        checkConnection methodName

        begin
            if  nil == remoteFileNames then
                #TODO debug
                ret = @con.listFiles
            else
                #TODO debug
                ret = @con.listFiles remoteFileNames.toutf8
            end
            if nil == localFileName then
                ret.each { |f| java.lang.System.out.println( f.toString ) }
            else
                begin
                    pathName = getLocalPathName( localFileName )
                    file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
                    outputStream = org.opentxp.txf.TxFileOutputStream.new file
                    printStream = java.io.PrintStream.new outputStream
                    ret.each { |f| printStream.println( f.toString ) }
                ensure
                    if nil != printStream then
                        printStream.close
                        printStream = nil
                    end
                    if nil != outputStream then
                        outputStream.close
                        outputStream = nil
                    end
                end
            end
            printFtpStatistics

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Terminate ftp session
    #
    public
    def disconnect

        methodName = "disconnect"
        TRACE methodName, "R}hs܂"

        begin

            if true == @con.isConnected then
                @con.disconnect()
            end

        rescue NativeException => e
            #null()
        end

        TRACE methodName, "R}h܂"

    end

    #
    #exit
    #
    public
    def exit
        quit
    end

    #
    #Receive file
    #
    public
    def get( remoteFileName = nil, localFileName = nil )

        methodName = "get"
        TRACE methodName, "R}hs܂ remoteFileName=#{remoteFileName}, localFileName=#{localFileName}"

        checkConnection methodName

        if  nil == remoteFileName then
            remoteFileName = readLine( "Remote file ", true )
            if nil == remoteFileName || "" == remoteFileName then
                doUsage methodName
            end
        end
        if  nil == localFileName then
            localFileName = remoteFileName
        end

        begin

            pathName = getLocalPathName( localFileName )
            file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
            if false == file.exists then
                file.createNewFile
            end
            outputStream = org.opentxp.txf.TxFileOutputStream.new file
            @con.retrieveFile remoteFileName.toutf8, outputStream
            printFtpStatistics

            NOTIFY methodName, "[gt@C(#{remoteFileName})[Jt@C(#{localFileName})ɎM܂"

        #TODO File G[
        rescue NativeException => e
            onFtpError methodName, e
        ensure
            if nil != outputStream then
                outputStream.close
                outputStream = nil
            end
        end


    end

    #
    #Toggle metacharacter expansion of local file names
    #
    public
    def glob

        methodName = "glob"
        TRACE methodName, "R}hs܂"

        @globbing = !@globbing
        printMode "Globbing", @globbing

        INFO methodName, "Ou[h#{@globbing}ɐݒ肵܂"

    end

    #
    #Toggle printing `#' for each buffer transferred
    #
    public
    def hash

        methodName = "hash"
        TRACE methodName, "R}hs܂"

        @hashMarkPrinting = !@hashMarkPrinting
        printHashMarkPrinting

        INFO methodName, "nbV\[h#{@hashMarkPrinting}ɐݒ肵܂"

    end

    #
    #Print local help information
    #
    public
    def help( command = nil )

        methodName = "help"
        TRACE methodName, "R}hs܂ command=#{command}"

        if ( nil == command )
            printHelpList
        else
            printDescription command
        end

        TRACE methodName, "R}h܂"

    end

    #
    #image
    #
    public
    def image()
        binary()
    end

    #
    #Change local working directory
    #
    public
    def lcd( dirName = nil )

        methodName = "lcd"
        TRACE methodName, "R}hs܂ dirName=#{dirName}"

        if  nil == dirName then
            puts "Local directory now \"#{@localDirectory}\"."
        else
            pathName = getLocalPathName( dirName )
            dirF = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
            checkLocalDirectory dirF
            jstrDir = dirF.getCanonicalPath
            @localDirectory = Kconv.kconv jstrDir, Kconv::SJIS, Kconv::UTF8
            puts "Local directory now \"#{@localDirectory}\"."
            NOTIFY methodName, "[JfBNg(#{@localDirectory})ɕύX܂"
        end

    end
2
    #
    #copy local file
    #
    public
    def lcopy( fromFileName, toFileName )

        methodName = "lcopy"
        TRACE methodName, "R}hs܂ fromFileName=#{fromFileName}, toFileName=#{toFileName}"

        pathNameFrom = getLocalPathName( fromFileName )
        fileFrom = org.opentxp.txf.TxFile.new @trans, pathNameFrom.toutf8
        if false == fileFrom.exists
            puts "Local file is not found."
            WARNING methodName, "[Jt@C(#{fromFileName})݂܂"
            return false
        end

        #TODO ݂fBNgւ̃Rs[̏ꍇ́H
        pathNameTo = getLocalPathName( toFileName )
        fileTo = org.opentxp.txf.TxFile.new @trans, pathNameTo.toutf8
        fRet = fileFrom.copyTo fileTo
        if true != fRet then
            #TODO Rs[łȂƂ͗Oł͂Ȃ̂H
            puts "Copy local file is failed ."
            ERROR methodName, "[Jt@C(#{localFileName})Vt@C(#{toFileName})ɃRs[ł܂ł"
            return false
        end

        puts "Local file is copied."
        NOTIFY methodName, "[Jt@C(#{fromFileName})Vt@C(#{toFileName})ɃRs[܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #Delete local file
    #
    public
    def ldelete( localFileName )

        #ldeleteɃChJ[hw͕KvH
        methodName = "ldelete"
        TRACE methodName, "R}hs܂ localFileName=#{localFileName}"

        pathName = getLocalPathName( localFileName )
        file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
        if false == file.exists
            puts "Local file is not found."
            WARNING methodName, "[Jt@C(#{localFileName})݂܂"
            return false
        elsif true == file.isDirectory
            puts "Local file is a directory."
            WARNING methodName, "[Jt@C(#{localFileName})̓fBNgł"
            return false
        end

        fRet = file.delete
        if true != fRet then
            #TODO 폜łȂƂ͗Oł͂Ȃ̂H
            puts "Delete local file is failed ."
            ERROR methodName, "[Jt@C(#{localFileName})폜ł܂ł"
            return false
        end

        puts "Local file is deleted."
        NOTIFY methodName, "[Jt@C(#{localFileName})폜܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #exist check local file
    #
    public
    def lexists( localFileName )

        methodName = "lexists"
        TRACE methodName, "R}hs܂ localFileName=#{localFileName}"

        pathName = getLocalPathName( localFileName )
        file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
        if false == file.exists
            puts "Local file is not exists."
        INFO methodName, "[Jt@C(#{localFileName})݂͑܂ł"
            return false
        end

        puts "Local file is exists."
        INFO methodName, "[Jt@C(#{localFileName})݂͑܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #Send arbitrary ftp command
    #
    public
    def literal( line = nil )

        methodName = "literal"
        TRACE methodName, "R}hs܂ line=#{line}"

        checkConnection methodName

        if  nil == line then
            line = readLine( "Command line to send ", true )
            if nil == line || "" == line then
                doUsage methodName
            end
        end

        begin

            @con.sendCommand line.toutf8

            NOTIFY methodName, "[gR}h(#{line})s܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #List contents of local directory
    #
    public
    def lls( localFiles = nil )

        methodName = "lls"
        TRACE methodName, "R}hs܂ localFiles=#{localFiles}"

        if  nil == localFiles then
            localFiles = "*"
        elsif "-" == localFiles[0, 1] then
            raise ArgumentError
        end

        pathName = getLocalPathName( @localDirectory )
        dirF = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
        checkLocalDirectory dirF
        list = dirF.list localFiles

        list.each { |f| java.lang.System.out.println( f ) }

        TRACE methodName, "R}h܂"

    end

    #
    #Make local directory
    #
    public
    def lmkdir( dirName )

        methodName = "lmkdir"
        TRACE methodName, "R}hs܂ dirName=#{dirName}"

        pathName = getLocalPathName( dirName )
        dirF = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
        if true == dirF.exists && true == dirF.isDirectory then
            puts "Local directory is already exists."
            WARNING methodName, "[JfBNg(#{dirName})ɑ݂܂"
            return false
        elsif true == dirF.exists && false == dirF.isDirectory then
            puts "Same name local file is exists."
            WARNING methodName, "̃[Jt@C(#{dirName})݂܂"
            return false
        end

        fRet = dirF.mkdir
        if true != fRet then
            #TODO OύXłȂƂ͗Oł͂Ȃ̂H
            puts "Make local directory is failed ."
            ERROR methodName, "[JfBNg(#{dirName})쐬ł܂ł"
            return false
        end

        puts "Local directory is made."
        NOTIFY methodName, "[JfBNg(#{dirName})쐬܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #Get local working directory
    #
    public
    def lpwd
        lcd
    end

    #
    #Rename local file
    #
    public
    def lrename( fromFileName, toFileName )

        methodName = "lrename"
        TRACE methodName, "R}hs܂ fromFileName=#{fromFileName}, toFileName=#{toFileName}"

        pathNameFrom = getLocalPathName( fromFileName )
        fileFrom = org.opentxp.txf.TxFile.new @trans, pathNameFrom.toutf8
        if false == fileFrom.exists
            puts "Local file is not found."
            WARNING methodName, "[Jt@C(#{fromFileName})݂܂"
            return false
        end

        #TODO ݂fBNgւ̖OύX̏ꍇɂ͈ړH
        pathNameTo = getLocalPathName( toFileName )
        fileTo = org.opentxp.txf.TxFile.new @trans, pathNameTo.toutf8
        fRet = fileFrom.renameTo fileTo
        if true != fRet then
            #TODO OύXłȂƂ͗Oł͂Ȃ̂H
            puts "Rename local file is failed ."
            ERROR methodName, "[Jt@C(#{localFileName})Vt@C(#{toFileName})ɖOύXł܂ł"
            return false
        end

        puts "Local file is renamed."
        NOTIFY methodName, "[Jt@C(#{fromFileName})Vt@C(#{toFileName})ɖOύX܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #Delete local directory
    #
    public
    def lrmdir( localFileName )

        methodName = "lrmdir"
        TRACE methodName, "R}hs܂ localFileName=#{localFileName}"

        pathName = getLocalPathName( localFileName )
        file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
        if false == file.exists
            puts "Local directory is not found."
            WARNING methodName, "[JfBNg(#{localFileName})݂܂"
            return false
        elsif false == file.isDirectory
            puts "Local file is not a directory."
            WARNING methodName, "[Jt@C(#{localFileName})̓fBNgł͂܂"
            return false
        end

        fRet = file.delete
        if true != fRet then
            #TODO 폜łȂƂ͗Oł͂Ȃ̂H
            puts "Delete local directory is failed ."
            ERROR methodName, "[JfBNg(#{localFileName})폜ł܂ł"
            return false
        end

        puts "Local directory is deleted."
        NOTIFY methodName, "[JfBNg(#{localFileName})폜܂"

        TRACE methodName, "R}h܂"

        return true

    end

    #
    #List contents of remote directory
    #
    public
    def ls( remoteFileNames = nil, localFileName = nil )

        methodName = "ls"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}, localFileName=#{localFileName}"

        checkConnection methodName

        begin

            if  nil == remoteFileNames then
                ret = @con.listNames
            else
                ret = @con.listNames remoteFileNames.toutf8
            end
            if nil == ret then
                WARNING methodName, "R}hs܂(#{@con.getReplyString()})"
                return
            end

        rescue NativeException => e
            onFtpError methodName, e
        end

        if nil == localFileName then
            ret.each { |f| java.lang.System.out.println( f ) }
        else
            begin
                pathName = getLocalPathName( localFileName )
                file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
                if !file.exists then
                    file.createNewFile
                end
                outputStream = org.opentxp.txf.TxFileOutputStream.new file
                printStream = java.io.PrintStream.new outputStream
                ret.each { |f| printStream.println( f ) }
                INFO methodName, "[gt@C(#{remoteFileNames})̃t@CXg[Jt@C(#{localFileName})ɎM܂"

                printFtpStatistics

                TRACE methodName, "R}h܂"

            #TODO rescue
            ensure
                if nil != printStream then
                    printStream.close
                    printStream = nil
                end
                if nil != outputStream then
                    outputStream.close
                    outputStream = nil
                end
            end
        end

    end

    #
    #Toggle local transaction mode
    #
    public
    def ltrans()

        methodName = "ltrans"
        TRACE methodName, "R}hs܂"

        if false == @@sys_ltransFlag then
            raise "This system does not support Transactional NTFS."
        else

            @ltransFlag = !@ltransFlag
            printMode "Local transaction mode", @ltransFlag
            INFO methodName, "[JgUNV[h#{@ltrans}ɐݒ肵܂"

            ltxbegin

        end

        TRACE methodName, "R}h܂"

    end

    #
    #begin local transaction
    #
    public
    def ltxbegin

        methodName = "ltxbegin"
        TRACE methodName, "R}hs܂"

        if true == @ltransFlag
            if nil != @trans then
                @trans.close
            end
            @trans = org.opentxp.txf.TxFileTransaction::begin
        else
            @trans = org.opentxp.txf.TxFileTransaction.NULL_TRANSACTION
        end
        puts "begin local transaction, id = \{#{@trans.getTransactionId}\}."

        NOTIFY methodName, "[JgUNV(#{@trans.getTransactionId})Jn܂"

        TRACE methodName, "R}h܂"

    end

    #
    #Delete multiple files
    #
    public
    def mdelete( remoteFileNames )

        methodName = "mdelete"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}"

        checkConnection methodName

        if  nil == remoteFileNames then
            remoteFileNames = readLine( "Remote files ", true )
            if nil == remoteFileNames || "" == remoteFileNames then
                doUsage methodName
            end
        end

        begin

            #get names list
            listFileNames = @con.listNames( remoteFileNames.toutf8 )
            if nil == listFileNames then
                ERROR methodName, "R}hs܂(#{@con.getReplyString()})"
                return
            end

            INFO methodName, "[gt@C(#{remoteFileNames})폜܂"

            ans = ""
            listFileNames.each { |remoteFileName|

                ans = readAnswer( "mdelete #{remoteFileName}", "anpqy", ans )
                if "y" == ans || "a" == ans then
                    delete remoteFileName
                    NOTIFY methodName, "[gt@C(#{remoteFileName})폜܂"
                elsif "n" == ans then
                    #nop
                    INFO methodName, "[gt@C(#{remoteFileName})͍폜܂ł"
                elsif "q" == ans then
                    break
                end

            }
            if "q" == ans then
                INFO methodName, "[gt@C(#{remoteFileName})̍폜悤ƂƂŒf܂"
            else
                INFO methodName, "[gt@C폜܂"
            end

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #List contents of multiple remote directories
    #
    public
    def mdir remoteFileNames = nil , localFileName = nil

        methodName = "mdir"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}, localFileName=#{localFileName}"
        checkConnection methodName

        if  nil == remoteFileNames then
            remoteFileNames = readLine( "Remote files ", true )
            if nil == remoteFileNames || "" == remoteFileNames then
                doUsage methodName
            end
        end

        begin

            if  nil == localFileName then
                localFileName = readLine( "local file ", true )
                if nil == localFileName || "" == localFileName then
                    localFileName = nil
                else
                    ans = readAnswer( "output to local-file: #{localFileName}", "ny", ans )
                    if "y" != ans then
                        return
                    end
                end
            end

            dir remoteFileNames, localFileName

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Get multiple files
    #
    public
    def mget( remoteFileNames = nil )

        methodName = "mget"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}"

        checkConnection methodName

        if  nil == remoteFileNames then
            remoteFileNames = readLine( "Remote files ", true )
            if nil == remoteFileNames || "" == remoteFileNames then
                doUsage methodName
            end
        end

        begin

            #get names list
            INFO methodName, "[gt@C(#{remoteFileNames})M܂"

            ans = ""
            listFileNames = @con.listNames( remoteFileNames.toutf8 )
            listFileNames.each { |remoteFileName|

                ans = readAnswer( "mget #{remoteFileName}", "anpqy", ans )
                if "y" == ans || "a" == ans then
                    get remoteFileName
                    NOTIFY methodName, "[gt@C(#{remoteFileName})M܂"
                elsif "n" == ans then
                    #nop
                elsif "q" == ans then
                    break
                end

            }
            if "q" == ans then
                INFO methodName, "[gt@C(#{remoteFileName})̎M悤ƂƂŒf܂"
            else
                INFO methodName, "[gt@CM܂"
            end

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Make directory on the remote machine
    #
    public
    def mkdir( dirName = nil )

        methodName = "mkdir"
        TRACE methodName, "R}hs܂ dirName=#{dirName}"

        checkConnection methodName

        if  nil == dirName then
            dirName = readLine( "Directory name ", true )
            if nil == dirName || "" == dirName then
                doUsage methodName
            end
        end

        begin

            ret = @con.makeDirectory( dirName.toutf8 )

            NOTIFY methodName, "[gfBNg(#{dirName})쐬܂"

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #List contents of multiple remote directories
    #
    public
    def mls( remoteFileNames = nil, localFileName = nil )

        methodName = "mls"
        TRACE methodName, "R}hs܂ remoteFileNames=#{remoteFileNames}, localFileName=#{localFileName}"

        checkConnection methodName

        if  nil == remoteFileNames then
            remoteFileNames = readLine( "Remote files ", true )
            if nil == remoteFileNames || "" == remoteFileNames then
                doUsage methodName
            end
        end

        begin

            if  nil == localFileName then
                localFileName = readLine( "local file ", true )
                if nil == localFileName || "" == localFileName then
                    localFileName = nil
                else
                    ans = readAnswer( "output to local-file: #{localFileName}", "ny", ans )
                    if "y" != ans then
                        return
                    end
                end
            end

            ls remoteFileNames, localFileName

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Send multiple files
    #
    public
    def mput( localFileNames = nil )

        methodName = "mput"
        TRACE methodName, "R}hs܂ localFileNames=#{localFileNames}"

        checkConnection methodName

        if  nil == localFileNames then
            localFileNames = readLine( "Local files ", true )
            if nil == localFileNames || "" == localFileNames then
                doUsage methodName
            end
        end

        begin

            #get names list
            INFO methodName, "[Jt@C(#{localFileNames})𑗐M܂"

            ans = ""
            curpathF = org.opentxp.txf.TxFile.new @trans, ".";
            listFileNames = curpathF.list localFileNames
            listFileNames.each { |fileName|

                ans = readAnswer( "mput #{fileName}", "anpqy", ans )
                if "y" == ans || "a" == ans then
                    put fileName
                    NOTIFY methodName, "[Jt@C(#{localFileNames})𑗐M܂"
                elsif "n" == ans then
                    #nop
                    INFO methodName, "[Jt@C(#{localFileNames})͑M܂ł"
                elsif "q" == ans then
                    break
                end

            }
            if "q" == ans then
                INFO methodName, "[Jt@C(#{localFileNames})̑M悤ƂƂŒf܂"
            else
                INFO methodName, "[Jt@CM܂"
            end

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Connect to remote ftp
    #
    public
    def open( svrname = @defaultServerName, portno = @defaultPortNo )

        methodName = "open"
        TRACE methodName, "R}hs܂ svrname=#{svrname}, portno=#{portno}"

        if nil == portno then
            con_info_msg = "#{svrname}:(none)"
        else
            con_info_msg = "#{svrname}:#{portno.to_s}"
        end

        #
        #connect
        #
        begin
            puts "connect #{svrname} ... "
            if nil == portno then
                ret = @con.connect( svrname.toutf8 )
            else
                ret = @con.connect( svrname.toutf8, portno.to_i )
            end
            if true == @passiveMode then
                @con.enterLocalPassiveMode()
            end
        rescue NativeException => e
            msg = e.cause.getMessage
            puts msg
            ERROR methodName, "[gzXg(#{con_info_msg})ɐڑł܂ł G[(#{msg})"
            return
        end

        #TODO ڑݒ
        @serverName = svrname
        @portno = portno
        @type = "ascii"
        @con.setControlEncoding @serverEncoding

        NOTIFY methodName, "[gzXg(#{con_info_msg})ɐڑ܂"

        #
        #login
        #
        begin

            if false == @anonymous then

                #userName
                if nil != portno then
                    prompt_user = "User (#{svrname}:#{portno.to_s}) : "
                else
                    prompt_user = "User (#{svrname}:(none)) : "
                end
                userName = readLine prompt_user, true, false
                if nil == userName || "" == userName then
                    puts "" if nil == userName
                    WARNING methodName, "[U͂Œf܂"
                    return
                end
                @con.user( userName.toutf8 )

                #password
                password = readPassword "password : "
                if nil == password  then
                    puts ""
                    WARNING methodName, "pX[h͂Œf܂"
                    return
                end
                if 0 == password.length then
                    WARNING methodName, "pX[h͂Œf܂"
                    return
                end

                rc = @con.pass( password.toutf8 )
                password = "********"

                if 230 == rc then
                    NOTIFY methodName, "[U(#{userName})ŃOC܂"
                else
                    puts "login failed."
                    WARNING methodName, "[U(#{userName})ŃOCł܂ł"
                    return
                end

            else    # anonymous

                userName = "anonymous"
                password = "anonymous"
                fSuccess = @con.login( userName.toutf8, password.toutf8 )
                password = "********"
                if true == fSuccess then
                    INFO methodName, "anonymousł̃OC܂"
                else
                    WARNING methodName, "anonymousł̃OC܂"
                    return
                end

            end

            @userName = userName

            #TODO ݂̃[gfBNgNOTIFYKvȂ̂ł́H

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            password = "****"
            closeConnectionWhenError
        end


    end

    #
    #Toggle pasive mode
    #
    public
    def passive()

        methodName = "passive"
        TRACE methodName, "R}hs܂"

        @passiveMode = !@passiveMode
        printMode "Passive mode", @passiveMode

        INFO methodName, "pbVu][h#{@passiveMode}ɐݒ肵܂"

        TRACE methodName, "R}h܂"

    end


    #
    #Force interactive prompting on multiple commands
    #
    public
    def prompt

        methodName = "prompt"
        TRACE methodName, "R}hs܂"

        @interactive = !@interactive
        printMode "Interactive mode", @interactive

        INFO methodName, "C^NeBu[h#{@interactive}ɐݒ肵܂"
        TRACE methodName, "R}h܂"

    end

    #
    #Send one file
    #
    public
    def put( localFileName = nil, remoteFileName = nil )

        methodName = "put"
        TRACE methodName, "R}hs܂ localFileName=#{localFileName}, remoteFileName=#{remoteFileName}"

        checkConnection methodName

        if  nil == localFileName then
            localFileName = readLine( "Local file ", true )
            if nil == localFileName || "" == localFileName then
                doUsage methodName
            end
        end
        if  nil == remoteFileName then
            remoteFileName = localFileName
        end
        begin

            pathName = getLocalPathName( localFileName )
            file = org.opentxp.txf.TxFile.new @trans, pathName.toutf8
            inputStream = org.opentxp.txf.TxFileInputStream.new file
            @con.storeFile remoteFileName.toutf8, inputStream
            printFtpStatistics
            inputStream.close
            inputStream = nil

            NOTIFY methodName, "[Jt@C(#{localFileName})[gt@C(#{remoteFileName})ɑM܂"

        #TODO File Error
        rescue NativeException => e
            onFtpError methodName, e
        ensure
            if nil != inputStream then
                inputStream.close
                inputStream = nil
            end
        end

        TRACE methodName, "R}h܂"

    end

    #
    #Print working directory on remote machine
    #
    public
    def pwd()

        methodName = "pwd"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            @con.printWorkingDirectory()

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Terminate ftp session and exit
    #
    public
    def quit()

        methodName = "quit"
        TRACE methodName, "R}hs܂"

        @quit = true
        close

        TRACE methodName, "R}h܂"

    end

    #
    #Send arbitrary ftp command
    #
    public
    def quote( line )
        literal line
    end

    #
    #Receive file
    #  always binary
    #
    public
    def recv( remoteFileName = nil, localFileName = nil )
        get remoteFileName, localFileName
    end

    #
    #Get help from remote server
    #
    public
    def remotehelp( command = nil )

        methodName = "remotehelp"
        TRACE methodName, "R}hs܂ command=#{command}"

        checkConnection methodName

        begin

            if nil == command then
                ret = @con.listHelp
            else
                ret = @con.listHelp command
            end

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Rename file
    #
    public
    def rename( fromFileName = nil, toFileName = nil )

        methodName = "rename"
        TRACE methodName, "R}hs܂ fromFileName=#{fromFileName}, toFileName=#{toFileName}"

        checkConnection methodName

        if  nil == fromFileName then
            fromFileName = readLine( "From name ", true )
            if nil == fromFileName || "" == fromFileName then
                doUsage methodName
            end
            toFileName = readLine( "To name ", true )
            if nil == toFileName || "" == toFileName then
                doUsage methodName
            end
        end

        begin

            ret = @con.rename( fromFileName.toutf8, toFileName.toutf8 )

            NOTIFY methodName, "[gt@C(#{fromFileName})Vt@C(#{toFileName})ɕύX܂"

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Get help from remote server
    #
    public
    def rhelp( command = nil )
        remotehelp command
    end

    #
    #Remove directory on the remote machine
    #
    public
    def rmdir( dirName = nil )

        methodName = "rmdir"
        TRACE methodName, "R}hs܂ dirName=#{dirName}"

        checkConnection methodName

        if  nil == dirName then
            dirName = readLine( "Directory name ", true )
            if nil == dirName || "" == dirName then
                doUsage methodName
            end
        end

        begin

            ret = @con.removeDirectory( dirName.toutf8 )

            NOTIFY methodName, "[gfBNg(#{dirName})폜܂"

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Rollback transaction
    #
    public
    def rollback

        methodName = "rollback"
        TRACE methodName, "R}hs܂"

        if @trans == org.opentxp.txf.TxFileTransaction.NULL_TRANSACTION then
            puts "Warning : Current local transaction is NULL_TRANSACTION."
            return
        end
        @trans.rollback
        puts "rollback local transaction, id = \{#{@trans.getTransactionId}\}."

        NOTIFY methodName, "[JgUNV(#{@trans.getTransactionId})[obN܂"

        ltxbegin

        TRACE methodName, "R}h܂"

    end

    #
    #Show current status
    #
    public
    def rstatus()

        methodName = "rstatus"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            ret = @con.getStatus()

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Execute command script
    #
    public
    def runc( scriptName )

        methodName = "runc"
        TRACE methodName, "R}hs܂ scriptName=#{scriptName}"

        if nil == scriptName then
            raise ArgumentError
        end

        INFO methodName, "R}hXNvg(#{scriptName})s܂"

        file = File.new scriptName
        while !file.eof?
            begin

                line = file.gets
                if  nil == line  || "" == line then
                    break
                end

                args = Shellwords.shellwords( line )
                cmd = args.shift
                if nil == cmd || "" == cmd then
                    next
                elsif cmd == "!" then
                    #TODO
                    next
                elsif cmd == "?" then
                    help
                else
                    line = cmd
                    args.each { |str| line += " \'#{str}\'," }
                    line.chop! if line[line.length-1, line.length] == ","

                    begin
                        ret = instance_eval( line )
                    rescue NameError => e
                        puts e
                        puts "Invalid command."
                    rescue ArgumentError => e
                        puts e
                        puts "Invalid parameters."
                    rescue => e
                        puts e
                    end
                end

            end

        end

        INFO methodName, "R}hXNvg(#{scriptName})̎sI܂"

        TRACE methodName, "R}h܂"

    end

    #
    #Execute ruby script
    #
    public
    def runr( scriptName )

        methodName = "runr"
        TRACE methodName, "R}hs܂ scriptName=#{scriptName}"

        if nil == scriptName then
            raise ArgumentError
        end

        INFO methodName, "rubyXNvg(#{scriptName})s܂"

        line = ""
        file = File.open scriptName, "r"
        while !file.eof?
            line << file.gets
        end
        file.close

        begin
            ret = instance_eval( line )
        rescue NameError => e
            puts e
            puts "Invalid command."
        rescue ArgumentError => e
            puts e
            puts "Invalid parameters."
        rescue => e
            puts e
        end

        INFO methodName, "rubyXNvg(#{scriptName})̎sI܂"

        TRACE methodName, "R}h܂"

    end

    #
    #Send one file
    #  always binary
    #
    public
    def send( localFileName = nil, remoteFileName = nil )
        put localFileName, remoteFileName
    end

    #
    #Send site command
    #
    public
    def site( args = nil )

        methodName = "site"
        TRACE methodName, "R}hs܂ args=#{args}"

        checkConnection methodName

        if  nil == args then
            args = readLine( "Arguments ", true )
            if nil == args || "" == args then
                doUsage methodName
            end
        end

        begin

            ret = @con.sendSiteCommand( args.toutf8 )

            NOTIFY methodName, "TCgR}h(#{args})s܂"

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Show current status
    #
    public
    def status()

        methodName = "status"
        TRACE methodName, "R}hs܂"
        if true == @con.isConnected then
            if nil == @portno then
                con_status = "connect to #{@serverName}:(none)"
            else
                con_status = "connect to #{@serverName}:#{portno.to_s}"
            end
        else
            con_status = "Not connected."
        end
        type_status = @type
        passive_status = getModeString @passiveMode
        verbose_status = getModeString @verbosing
        bell_status = getModeString @bell
        interactive_status = getModeString @interactive
        glob_status = getModeString @glob
        debug_status = getModeString @debugging
        hash_status = getModeString @hashMarkPrinting

        puts "#{con_status} \n" +
            "Type: #{type_status} ; " +
            "Passive: #{passive_status} ; " +
            "Verbose: #{verbose_status} ; " +
            "Bell: #{bell_status} ; " +
            "Prompting: #{interactive_status} ; \n" +
            "Globbing: #{glob_status} ; " +
            "Debugging: #{debug_status} ; " +
            "Hash mark printing: #{hash_status} ."

        puts "Local transaction, id = \{#{@trans.getTransactionId}\}."
        if false == @@sys_ltransFlag then
            puts "Warning : This system does not support Transactional NTFS."
        end

        TRACE methodName, "R}h܂"

    end

    #
    #Show remote system type
    #
    public
    def system()

        methodName = "system"
        TRACE methodName, "R}hs܂"

        checkConnection methodName

        begin

            # FTPClient::getSystemName()̓LbV邽߁AQڈȍ~̓zXg
            # ₢킹ɍsȂ̂ŁAł͎gȂB
            #systemName = @con.getSystemName
            nRet = @con.syst()
            if 215 == nRet then
                strReply = @con.getReplyString
                systemName = strReply[4, strReply.length].chomp
                INFO methodName, "[gzXg̃VXe(#{systemName})擾܂"
            else
                WARNING methodName, "[gzXg̃VXeR[h(#{nRet.to_s})Ŏ擾ł܂łB"
            end

            TRACE methodName, "R}h܂"

        rescue NativeException => e
            onFtpError methodName, e
        end

    end

    #
    #Toggle packet tracing
    #
    public
    def trace()

        methodName = "trace"
        TRACE methodName, "R}hs܂"

        @packetTracing = !@packetTracing
        printMode "Packet tracing", @packetTracing

        INFO methodName, "g[X[h#{@trace}ɐݒ肵܂"

        TRACE methodName, "R}h܂"

    end

    #
    #Set file transfer type
    #
    public
    def type( typeName = nil )

        methodName = "type"
        TRACE methodName, "R}hs܂ typeName=#{typeName}"

        checkConnection methodName

        if  nil == typeName then
            puts "Using " + @type + " mode to transfer files."
        elsif "ascii" == typeName then
            ascii
        elsif "binary" == typeName then
            binary
        else
            doUsage methodName
        end

        TRACE methodName, "R}h܂"

    end

    #
    #Show usage
    #
    public
    def usage( command = nil )

        methodName = "usage"
        TRACE methodName, "R}hs܂ command=#{command}"

        if nil == command then
            printHelpList
        else
            printUsage command
        end

        TRACE methodName, "R}h܂"

    end

    #
    #Send new user information
    #
    public
    def user( userName = nil, password = nil, account = nil )

        methodName = "user"
        TRACE methodName, "R}hs܂ userName=#{userName}"

        checkConnection methodName

        begin

            #  : anonymous[hŃ[Uw肪\ǂ̔f͂܂ŃT[oɈς˂

            # [UwȂAanonymous[h
            if ( nil == userName || "" == userName ) && ( true == @anonymous ) then

                userName = "anonymous"
                password = "anonymous"
                if nil == account then
                    fSuccess = @con.login( userName.toutf8, password.toutf8 )
                else
                    fSuccess = @con.login( userName.toutf8, password.toutf8, account.toutf8 )
                end
                password = "********"
                if true == fSuccess then
                    NOTIFY methodName, "anonymousŃOC܂"
                else
                    puts "login failed."
                    ERROR methodName, "anonymousŃOCł܂ł"
                    return
                end

            # [Uw肠Aanonymous[h
            # [Uw肠Aanonymous[h
            # [UwȂAanonymous[h
            else

                #userName
                if nil == userName || "" == userName then
                    userName = readLine "User name ", false
                    if nil == userName || "" == userName then
                        puts "" if nil == userName
                        INFO methodName, "[U͂Œf܂"
                        return
                    end
                end

                @con.user( userName.toutf8 )

                #pass
                if nil == password then
                    password = readPassword "Password "
                    if nil == password then
                        INFO methodName, "pX[h͂Œf܂"
                        return
                    end
                    if 0 == password.length then
                        WARNING methodName, "pX[h͂Œf܂"
                        return
                    end
                end

                rc = @con.pass( password.toutf8 )
                password = "********"
                if 230 == rc then
                    #account
                    if nil != account then
                        rc = @con.acct account.toutf8
                        if 200 == rc then
                            NOTIFY methodName, "[U(#{userName})ŃOC܂"
                        else
                            puts "login failed."
                            ERROR methodName, "[U(#{userName})ŃOCł܂ł"
                            return
                        end
                    else
                        NOTIFY methodName, "[U(#{userName})ŃOC܂"
                    end
                else
                    puts "login failed."
                    ERROR methodName, "[U(#{userName})ŃOCł܂ł"
                    return
                end

            end

            @user = userName
            TRACE methodName, "R}h܂"

        rescue NativeException => e
            password = "****"
            closeConnectionWhenError
            msg = e.cause.getMessage
            puts "txpFTP : #{msg}"
            ERROR methodName, "ڑG[ƂȂ܂ G[(#{msg})"
            return
        end

    end

    #
    #Toggle verbose mode
    #
    public
    def verbose()

        methodName = "verbose"
        TRACE methodName, "R}hs܂"

        @verbosing = !@verbosing
        printMode "Verbose mode", @verbosing

        INFO methodName, "ڍו\[h#{@verbosing}ɐݒ肵܂"

        TRACE methodName, "R}h܂"

    end

#-----------------------------------------------------------------------------
# message tables
#-----------------------------------------------------------------------------

    #help description
    protected
    @@help_description = {
        "!"         =>  "Escape to the shell",
        "?"         =>  "Print local help information",
        "append"    =>  "Append to a file",
        "ascii"     =>  "Set ascii transfer type",
        "bell"      =>  "Beep when command completed",
        "binary"    =>  "Set binary transfer type",
        "bye"       =>  "Terminate ftp session and exit",
        "cd"        =>  "Change remote working directory",
        "cdup"      =>  "Change remote working directory to the parent",
        "close"     =>  "Terminate ftp session",
        "commit"    =>  "Commit transaction",
        "delete"    =>  "Delete remote file",
        "debug"     =>  "Toggle debugging mode",
        "dir"       =>  "List contents of remote directory",
        "disconnect"=>  "Terminate ftp session",
        "exit"      =>  "Terminate ftp session and exit",
        "get"       =>  "Receive file",
        "glob"      =>  "Toggle metacharacter expansion of local file names",
        "hash"      =>  "Toggle printing `#' for each buffer transferred",
        "help"      =>  "Print local help information",
        "image"     =>  "Set binary transfer type",
        "lcd"       =>  "Change local working directory",
        "lcopy"     =>  "Copy local file",
        "ldelete"   =>  "Delete local file",
        "lexists"   =>  "Check local file exists",
        "literal"   =>  "Send arbitrary ftp command",
        "lls"       =>  "List contents of local directory",
        "lmkdir"    =>  "Make local directory",
        "lpwd"      =>  "Show local working directory",
        "lrename"   =>  "Rename local file",
        "lrmdir"    =>  "Delete local directory",
        "ls"        =>  "List contents of remote directory",
        "ltrans"    =>  "Toggle local transaction mode",
        "ltxbegin"  =>  "Begin local transaction",
        "mdelete"   =>  "Delete multiple files",
        "mdir"      =>  "List contents of multiple remote directories",
        "mget"      =>  "Get multiple files",
        "mkdir"     =>  "Make directory on the remote machine",
        "mls"       =>  "List contents of multiple remote directories",
        "mput"      =>  "Send multiple files",
        "open"      =>  "Connect to remote tftp",
        "passive"   =>  "Toggle passive transfer mode",
        "prompt"    =>  "Force interactive prompting on multiple commands",
        "put"       =>  "Send one file",
        "pwd"       =>  "Print working directory on remote machine",
        "quit"      =>  "Terminate ftp session and exit",
        "quote"     =>  "Send arbitrary ftp command",
        "recv"      =>  "Receive file",
        "remotehelp"=>  "Get help from remote server",
        "rename"    =>  "Rename file",
        "rhelp"     =>  "Get help from remote server",
        "rmdir"     =>  "Remove directory on the remote machine",
        "rollback"  =>  "Rollback transaction",
        "rstatus"   =>  "Show remote status",
        "runc"      =>  "Execute command script",
        "runr"      =>  "Execute ruby script",
        "send"      =>  "Send one file",
        "site"      =>  "Send site command",
        "status"    =>  "Show current status",
        "system"    =>  "Show remote system type",
        "trace"     =>  "Toggle packet tracing",
        "type"      =>  "Set file transfer type",
        "usage"     =>  "Show Usage",
        "user"      =>  "Send new user information",
        "verbose"   =>  "Toggle verbose mode",
        }

    #usage description
    protected
    @@usage_description = {
        "!"         =>  "",
        "?"         =>  "",
        "append"    =>  "local-file [remote-file]",
        "ascii"     =>  "",
        "bell"      =>  "",
        "binary"    =>  "",
        "bye"       =>  "",
        "cd"        =>  "remote-directory",
        "cdup"      =>  "",
        "close"     =>  "",
        "commit"    =>  "",
        "delete"    =>  "remote-file",
        "debug"     =>  "",
        "dir"       =>  "",
        "disconnect"=>  "",
        "exit"      =>  "",
        "get"       =>  "remote-file [local-file]",
        "glob"      =>  "",
        "hash"      =>  "",
        "help"      =>  "",
        "image"     =>  "",
        "lcd"       =>  "",
        "lcopy"     =>  "from-file to-file",
        "ldelete"   =>  "local-file",
        "lexists"   =>  "local-file",
        "literal"   =>  "line-to-send",
        "lls"       =>  "[local-files]",
        "lmkdir"   =>   "local-directory",
        "lpwd"      =>  "",
        "lrename"   =>  "from-file to-file",
        "lrmdir"   =>   "local-directory",
        "ls"        =>  "",
        "ltrans"    =>  "",
        "ltxbegin"  =>  "",
        "mdelete"   =>  "remote-files",
        "mdir"      =>  "remote-files [local-file]",
        "mget"      =>  "remote-files",
        "mkdir"     =>  "remote-directory",
        "mls"       =>  "remote-files local-file",
        "mput"      =>  "local-files",
        "open"      =>  "[host] [port-no]",
        "passive"   =>  "",
        "prompt"    =>  "",
        "put"       =>  "local-file [remote-directory]",
        "pwd"       =>  "",
        "quit"      =>  "",
        "quote"     =>  "",
        "recv"      =>  "remote-file [local-file]",
        "remotehelp"=>  "",
        "rename"    =>  "from-file to-file",
        "rhelp"     =>  "",
        "rmdir"     =>  "remote-directory",
        "rollback"  =>  "",
        "rstatus"   =>  "",
        "runc"      =>  "command-script",
        "runr"      =>  "ruby-script",
        "send"      =>  "local-file [remote-file]",
        "site"      =>  "args-to-send",
        "status"    =>  "",
        "system"    =>  "",
        "trace"     =>  "",
        "type"      =>  "[binary/ascii]",
        "usage"     =>  "[command]",
        "user"      =>  "",
        "verbose"   =>  "",
        }


end

#-----------------------------------------------------------------------------
# FTP Error
#-----------------------------------------------------------------------------

class FtpError < Exception

    def initialize( command, message, cause = nil )
        super message
        @command = command
        @cause = cause
    end

    attr_accessor   :cause
    attr_accessor   :command

end

