require 'shellwords'
require 'txpftpshell'
include Java

#print command usage
def doUsage
    STDERR.print <<EOF
******************************************************************************
 txpFTP ver 0.1.0 ( ftp/sftp with jruby scripting, and Transactional NTFS. )
 Copyright(c) 2008-2008 opentxp (http://www.opentxp.org) All Rights Reserved.
******************************************************************************

txpFTP [-h] [-p] [-v] [-d] [-i] [-n] [-g] { [-s:filename] | [-r:filename] }
       [-w:windowsize] [-l:logdir] [-A] [host]
  -h             Show command usage.
  -p             Enables passive transfer mode.
  -v             Suppresses display of remote server responses.
  -d             Enables debugging.
  -i             Turns off interactive prompting during multiple file
                 transfers.
  -n             Suppresses auto-login upon initial connection.
  -g             Disables filename globbing (see GLOB command).
  -s:filename    Specifies a text file containing FTP commands;
                 the commands will automatically run after FTP starts.
  -r:filename    Specifies a ruby script file; the script will
                 automatically run after FTP starts.
  -w:buffersize  Overrides the default transfer buffer size of 4096.
  -l:logdir      Specifies directory that log files will store.
                 \"./log\" is used when not specified.
  -A             login as anonymous.
  host           Specifies the host name or IP address of the remote
                 host to connect to.
EOF
    exit 254
end

# parse args
fCustomInitialScript = false
argPassive = false
argVerbose = true
argNoInitialConnect = false
argInteractive = true
argDebugging = false
argGlobbing = true
argHostName = nil
argInitialScriptName = "txpftpinit.rb"
argInitialScriptType = "ruby"
argAnonymous = false
argLogDir = ""

argc = ARGV.nitems
cnt = 1
ARGV.each { |arg|

    if "-" == arg[0,1] || "/" == arg[0,1] then
        if 2 == arg.length then
            case arg[1, 1]
                when "h"
                    doUsage
                when "p"
                    if 2 != arg.length then doUsage end
                    argPassive = !argPassive
                when "v"
                    if 2 != arg.length then doUsage end
                    argVerbose = !argVerbose
                when "n"
                    if 2 != arg.length then doUsage end
                    argNoInitialConnect = !argNoInitialConnect
                when "i"
                    if 2 != arg.length then doUsage end
                    argInteractive = !argInteractive
                when "d"
                    if 2 != arg.length then doUsage end
                    argDebugging = !argDebugging
                when "g"
                    if 2 != arg.length then doUsage end
                    argGlobbing = !argGlobbing
                when "A"
                    if 2 != arg.length then doUsage end
                    argAnonymous = !argAnonymous
                else
                    puts "Error : Unknown option #{arg}"
                    doUsage
            end
        else
            case arg[1, 2]
                when "s:"
                    if true == fCustomInitialScript then
                        doUsage
                    end
                    argInitialScriptType = "script"
                    argInitialScriptName = arg[3, arg.length-3]
                    fCustomInitialScript = true;
                when "r:"
                    if true == fCustomInitialScript then
                        doUsage
                    end
                    argInitialScriptType = "ruby"
                    argInitialScriptName = arg[3, arg.length-3]
                    fCustomInitialScript = true;
                when "w:"
                    strBufSize = arg[3, arg.length-3]
                    begin
                    argBufferSize = Integer( strBufSize )
                    rescue => e
                        puts "Error : invalid option #{arg}"
                        doUsage
                    end
                    #Not supported at this level
                    puts "Warning : -w option is not supported at this level."
                when "l:"
                    argLogDir = arg[3, arg.length-3]
                else
                    puts "Error : Unknown option #{arg}"
                    doUsage
            end
        end
        cnt += 1
    else
        if nil != argHostName then
            doUsage
        end
        argHostName = arg
    end

}


# check if java is 1.6 or later ?
java_version = java.lang.System.getProperty 'java.version'
if java_version < "1.6.0" then
    puts "Please use Java 1.6 or later"
    #TODO error?
    exit 255
else
    puts "Using java version is \"#{java_version}\"."
    #TODO info?
end

#set initial setting parsed by args
ftpShell = TxpFtpShell.new argHostName
ftpShell.passiveMode = argPassive
ftpShell.verbosing = argVerbose
ftpShell.interactive = argInteractive
ftpShell.debugging = argDebugging
ftpShell.globbing = argGlobbing
ftpShell.anonymous = argAnonymous
if "" != argLogDir then
    ftpShell.logdir = argLogDir
end

#initialize trap
Signal.trap( :INT ) {
    #puts "<CTRL+C>"
}

#exec initial script
if false == argNoInitialConnect then
    if "ruby" == argInitialScriptType then
        ftpShell.runr argInitialScriptName
    else
        ftpShell.runc argInitialScriptName
    end
end

#interpret
ftpShell.interpret

