/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class WildcardFilenameFilter
implements FilenameFilter {
    public static final String INPUT_FILENAME_DEFAULT = "*";
    public static final String INPUT_FILENAME_DEFAULT_REGEX = "[^\\.].*";
    private String regex_ = null;
    private Pattern pattern_ = null;

    public WildcardFilenameFilter() {
        this.regex_ = INPUT_FILENAME_DEFAULT_REGEX;
        this.pattern_ = Pattern.compile(this.regex_);
    }

    public WildcardFilenameFilter(String wildcard) {
        String regex = wildcard;
        regex = wildcard.replace(".", "[\\.]");
        regex = regex.replace("?", ".");
        regex = regex.replace(INPUT_FILENAME_DEFAULT, ".*");
        if (regex.startsWith(".")) {
            regex = "[^\\.]" + regex;
        }
        this.regex_ = regex;
        this.pattern_ = Pattern.compile(this.regex_);
    }

    @Override
    public boolean accept(File dir, String name) {
        Matcher matcher = null;
        matcher = this.pattern_.matcher(name);
        return matcher.matches();
    }
}

