/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import org.opentxp.txf.TxF32;
import org.opentxp.txf.TxFileTransaction;
import org.opentxp.txf.WildcardFilenameFilter;

public class TxFile {
    protected static String[] NO_NAMES = new String[0];
    private static TxF32 provider_ = null;
    private static int nPrefixLength_ = -1;
    private TxFileTransaction trans_ = null;
    private String strDir_ = null;
    private File file_ = null;
    protected static final int FILE_COPY_BUF_SIZE = 65536;
    protected static final ByteBuffer bufCopy_;

    TxF32 _getProvider() {
        return provider_;
    }

    String _getDir() {
        return this.strDir_;
    }

    File _getFile() {
        return this.file_;
    }

    TxFileTransaction _getTrans() {
        return this.trans_;
    }

    private TxFileTransaction _setTrans(TxFileTransaction trans) {
        TxFileTransaction bak = this.trans_;
        this.trans_ = trans;
        return bak;
    }

    public TxFile(TxFileTransaction trans, String parent, String child) {
        if (null == trans) {
            throw new NullPointerException("trans");
        }
        if (null == parent) {
            throw new NullPointerException("parent");
        }
        if (null == child) {
            throw new NullPointerException("child");
        }
        this.trans_ = trans;
        this.file_ = new File(parent, child);
        this.strDir_ = this.file_.getAbsolutePath();
    }

    public TxFile(TxFileTransaction trans, File file) {
        if (null == trans) {
            throw new NullPointerException("trans");
        }
        if (null == file) {
            throw new NullPointerException("file");
        }
        this.trans_ = trans;
        this.file_ = file;
        this.strDir_ = file.getAbsolutePath();
    }

    public TxFile(TxFileTransaction trans, String strPathName) {
        if (null == trans) {
            throw new NullPointerException("trans");
        }
        if (null == strPathName) {
            throw new NullPointerException("strPathName");
        }
        this.trans_ = trans;
        this.file_ = new File(strPathName);
        this.strDir_ = strPathName;
    }

    public boolean isTrans() {
        return null != provider_ && null != this.trans_ && TxFileTransaction.NULL_TRANSACTION != this.trans_;
    }

    int getPrefixLength() {
        int nRet;
        block4: {
            Method method = null;
            boolean fAccess = true;
            Integer objRet = null;
            nRet = -1;
            try {
                method = File.class.getDeclaredMethod("getPrefixLength", new Class[0]);
                fAccess = method.isAccessible();
                if (!fAccess) {
                    method.setAccessible(true);
                }
                objRet = (Integer)method.invoke((Object)this._getFile(), new Object[0]);
                nRet = objRet;
                if (!fAccess) {
                    method.setAccessible(false);
                }
            }
            catch (Exception e) {
                if (null == method || fAccess) break block4;
                method.setAccessible(false);
            }
        }
        return nRet;
    }

    public String getName() {
        String path = this._getDir();
        int prefixLength = this.getPrefixLength();
        int index = path.lastIndexOf(File.separatorChar);
        if (index < prefixLength) {
            return path.substring(prefixLength);
        }
        return path.substring(index + 1);
    }

    public String getParent() {
        String path = this.getPath();
        int prefixLength = this.getPrefixLength();
        int index = path.lastIndexOf(File.separatorChar);
        if (index < prefixLength) {
            if (0 < prefixLength && prefixLength < path.length()) {
                return path.substring(0, prefixLength);
            }
            return null;
        }
        return path.substring(0, index);
    }

    public String getPath() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this._getFile().getPath());
        }
        return this.strDir_;
    }

    public String getAbsolutePath() {
        String strRet = this._getFile().getAbsolutePath();
        return strRet;
    }

    public String getCanonicalPath() throws IOException {
        String strRet = this._getFile().getCanonicalPath();
        return strRet;
    }

    public boolean canRead() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            fRet = this._getProvider().canRead(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().canRead();
        }
        return fRet;
    }

    public boolean canWrite() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
                security.checkWrite(this._getFile().getPath());
            }
            fRet = this._getProvider().canWrite(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().canWrite();
        }
        return fRet;
    }

    public boolean exists() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            fRet = this._getProvider().exists(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().exists();
        }
        return fRet;
    }

    public boolean isDirectory() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            fRet = this._getProvider().isDirectory(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().isDirectory();
        }
        return fRet;
    }

    public boolean isFile() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            fRet = this._getProvider().isFile(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().isFile();
        }
        return fRet;
    }

    public boolean isHidden() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            fRet = this._getProvider().isHidden(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().isHidden();
        }
        return fRet;
    }

    public long lastModified() {
        long lRet = 0L;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            lRet = this._getProvider().getLastModified(this._getTrans(), this._getFile());
        } else {
            lRet = this._getFile().lastModified();
        }
        return lRet;
    }

    public long length() {
        long lRet = 0L;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this._getFile().getPath());
            }
            lRet = this._getProvider().getLength(this._getTrans(), this._getFile());
        } else {
            lRet = this._getFile().length();
        }
        return lRet;
    }

    public boolean setLastModified(long time) {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this._getFile().getPath());
            }
            fRet = this._getProvider().setLastModified(this._getTrans(), this._getFile(), time);
        } else {
            fRet = this._getFile().setLastModified(time);
        }
        return fRet;
    }

    public boolean setReadOnly() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().setReadOnly(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().setReadOnly();
        }
        return fRet;
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().setPermission(this._getTrans(), this._getFile(), 2, writable, ownerOnly);
        } else {
            fRet = this._getFile().setWritable(writable, ownerOnly);
        }
        return fRet;
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().setPermission(this._getTrans(), this._getFile(), 4, readable, ownerOnly);
        } else {
            fRet = this._getFile().setReadable(readable, ownerOnly);
        }
        return fRet;
    }

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().setPermission(this._getTrans(), this._getFile(), 1, executable, ownerOnly);
        } else {
            fRet = this._getFile().setExecutable(executable, ownerOnly);
        }
        return fRet;
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean canExecute() {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this._getFile().getPath());
            }
            fRet = this._getProvider().checkAccess(this._getTrans(), this._getFile(), 1);
        } else {
            fRet = this._getFile().canExecute();
        }
        return fRet;
    }

    public String[] list() {
        String[] astr = null;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkRead(this.file_.getPath());
            }
            astr = this._getProvider().list(this._getTrans(), this._getFile());
        } else {
            astr = this._getFile().list();
        }
        return astr;
    }

    public String[] list(String strWildCard) {
        String[] names = null;
        WildcardFilenameFilter filter = null;
        TxFile files = null;
        String dirName = null;
        String strTrueWildCard = null;
        TxFile txfParent = null;
        try {
            files = new TxFile(this._getTrans(), this._getFile().getCanonicalPath(), strWildCard);
            if (files.exists()) {
                txfParent = files;
                names = txfParent.list();
            } else {
                dirName = files.getParent();
                strTrueWildCard = files.getName();
                txfParent = new TxFile(this._getTrans(), dirName);
                filter = new WildcardFilenameFilter(strTrueWildCard);
                names = txfParent.list(filter);
            }
        }
        catch (Exception e) {
            names = null;
        }
        if (null == names) {
            names = NO_NAMES;
        }
        return names;
    }

    public String[] list(FilenameFilter filter) {
        String[] names = null;
        ArrayList<String> v = null;
        names = this.list();
        if (null != names && null != filter) {
            v = new ArrayList<String>();
            for (int i = 0; i < names.length; ++i) {
                if (!filter.accept(this._getFile(), names[i])) continue;
                v.add(names[i]);
            }
            names = v.toArray(new String[0]);
        }
        return names;
    }

    public boolean createNewFile() throws IOException {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this._getFile().getPath());
            }
            this._getProvider();
            fRet = TxF32.createFileExclusively(this._getTrans(), this._getFile().getPath());
        } else {
            fRet = this._getFile().createNewFile();
        }
        return fRet;
    }

    public boolean mkdir() throws IOException {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().createDirectory(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().mkdir();
        }
        return fRet;
    }

    public boolean delete() throws IOException {
        boolean fRet = false;
        if (this.isTrans()) {
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this.file_.getPath());
            }
            fRet = this._getProvider().delete(this._getTrans(), this._getFile());
        } else {
            fRet = this._getFile().delete();
        }
        return fRet;
    }

    public boolean renameTo(TxFile dest) throws IOException {
        boolean fRet = false;
        if (this.isTrans()) {
            if (null == dest) {
                new NullPointerException("dest");
            }
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this._getFile().getPath());
                security.checkWrite(dest.getPath());
            }
            fRet = this._getProvider().rename(this._getTrans(), this._getFile(), dest._getFile());
        } else {
            fRet = this._getFile().renameTo(dest._getFile());
        }
        return fRet;
    }

    public boolean copyTo(TxFile dest) throws IOException {
        boolean fRet = false;
        Object trans = null;
        if (this.isTrans()) {
            if (null == dest) {
                new NullPointerException("dest");
            }
            this._getTrans().checkSequence();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkWrite(this._getFile().getPath());
                security.checkWrite(dest.getPath());
            }
            fRet = !dest.exists() ? this._getProvider().copy(this._getTrans(), this._getFile(), dest._getFile()) : false;
        } else {
            try {
                TxFile.copyFile(this._getFile(), dest._getFile());
                fRet = true;
            }
            catch (Exception e) {
                fRet = false;
            }
        }
        return fRet;
    }

    protected static void copyFile(File fileSrc, File fileDst) throws IOException {
        FileInputStream fstreamSrc = null;
        FileOutputStream fstreamDst = null;
        FileChannel fchannelSrc = null;
        AbstractInterruptibleChannel fchannelDst = null;
        ByteBuffer buf = bufCopy_;
        assert (fileSrc != null);
        assert (fileDst != null);
        try {
            int nRead;
            fstreamSrc = new FileInputStream(fileSrc);
            fchannelSrc = fstreamSrc.getChannel();
            fstreamDst = new FileOutputStream(fileDst);
            fchannelDst = fstreamDst.getChannel();
            fchannelSrc.position(0L);
            buf.clear();
            for (long size = fileSrc.length(); 0L < size; size -= (long)nRead) {
                buf.clear();
                nRead = fchannelSrc.read(buf);
                buf.flip();
                ((FileChannel)fchannelDst).write(buf);
            }
            ((FileChannel)fchannelDst).force(true);
            fchannelDst.close();
            fchannelDst = null;
            fstreamDst.close();
            fstreamDst = null;
            fchannelSrc.close();
            fchannelSrc = null;
            fstreamSrc.close();
            fstreamSrc = null;
        }
        catch (IOException e) {
            if (null != fchannelDst) {
                try {
                    fchannelDst.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (null != fstreamDst) {
                try {
                    fstreamDst.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (null != fchannelSrc) {
                try {
                    fchannelSrc.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (null != fstreamSrc) {
                try {
                    fstreamSrc.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    static {
        try {
            provider_ = new TxF32();
        }
        catch (Throwable e) {
            provider_ = null;
        }
        bufCopy_ = ByteBuffer.allocate(65536);
    }
}

