/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import java.io.File;
import java.io.IOException;
import org.opentxp.txf.TxFileTransaction;

class TxF32 {
    private static final int INVALID_ATTRIBUTE_VALUE = 0;
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    public static final int ACCESS_READ = 4;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_EXECUTE = 1;
    public static final int SPACE_TOTAL = 0;
    public static final int SPACE_FREE = 1;
    public static final int SPACE_USABLE = 2;

    TxF32() {
    }

    private static String getAbsolutePathAsPlatformForm(File file) {
        String strCanonicalPath = null;
        String strRet = null;
        try {
            strCanonicalPath = file.getCanonicalPath();
            strRet = strCanonicalPath.replace("/", File.pathSeparator);
        }
        catch (IOException e) {
            strRet = null;
        }
        return strRet;
    }

    private static String getAbsolutePathAsPlatformForm(String strFileName) {
        File file = null;
        String strCanonicalPath = null;
        String strRet = null;
        try {
            file = new File(strFileName);
            strCanonicalPath = file.getCanonicalPath();
            strRet = strCanonicalPath.replace("/", File.pathSeparator);
        }
        catch (IOException e) {
            strRet = null;
        }
        return strRet;
    }

    public native int getBooleanAttributes(TxFileTransaction var1, File var2);

    public native boolean checkAccess(TxFileTransaction var1, File var2, int var3);

    public boolean exists(TxFileTransaction trans, File file) {
        int nAttr = -1;
        nAttr = this.getBooleanAttributes(trans, file);
        return 0 != (1 & nAttr);
    }

    public boolean isDirectory(TxFileTransaction trans, File file) {
        int nAttr = -1;
        nAttr = this.getBooleanAttributes(trans, file);
        return 0 != (4 & nAttr);
    }

    public boolean isFile(TxFileTransaction trans, File file) {
        int nAttr = -1;
        nAttr = this.getBooleanAttributes(trans, file);
        return 0 != (2 & nAttr);
    }

    public boolean isHidden(TxFileTransaction trans, File file) {
        int nAttr = -1;
        nAttr = this.getBooleanAttributes(trans, file);
        return 0 != (8 & nAttr);
    }

    public boolean canRead(TxFileTransaction trans, File file) {
        boolean fRet = false;
        fRet = this.checkAccess(trans, file, 4);
        return fRet;
    }

    public boolean canWrite(TxFileTransaction trans, File file) {
        boolean fRet = false;
        fRet = this.checkAccess(trans, file, 2);
        return fRet;
    }

    public native long getLastModified(TxFileTransaction var1, File var2);

    public native long getLength(TxFileTransaction var1, File var2);

    public native boolean setLastModified(TxFileTransaction var1, File var2, long var3);

    public native boolean setReadOnly(TxFileTransaction var1, File var2);

    public native boolean setPermission(TxFileTransaction var1, File var2, int var3, boolean var4, boolean var5);

    public boolean createNewFile(TxFileTransaction trans, String path) throws IOException {
        boolean fRet = false;
        fRet = TxF32.createFileExclusively(trans, path);
        return fRet;
    }

    protected static native boolean createFileExclusively(TxFileTransaction var0, String var1) throws IOException;

    public native boolean createDirectory(TxFileTransaction var1, File var2) throws IOException;

    public native boolean delete(TxFileTransaction var1, File var2) throws IOException;

    public native boolean rename(TxFileTransaction var1, File var2, File var3) throws IOException;

    public native boolean copy(TxFileTransaction var1, File var2, File var3) throws IOException;

    public native String[] list(TxFileTransaction var1, File var2);

    static {
        System.loadLibrary("TxF32");
    }
}

