/*
    setwindrv TiMidity++ config file ediotr.
    Copyright (C) 2006-2007 Keishi Suenaga <skeishi@yahoo.co.jp>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef _MSC_VER
#define _CRT_SECURE_NO_DEPRECATE
#endif 

#include <stdio.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#include <string.h>
#include "file_io.h"


#ifdef G_OS_WIN32
gchar *package_prefix = PACKAGE_PREFIX;
gchar *package_data_dir = PACKAGE_DATA_DIR;
gchar *package_locale_dir = PACKAGE_LOCALE_DIR;
#endif







int
main (int argc, char *argv[])
{
  GtkWidget *windrv_setup;
  

  gchar *pixmap_dir;
#ifdef G_OS_WIN32
  package_prefix = g_win32_get_package_installation_directory (NULL, NULL);
  package_data_dir = g_build_filename (package_prefix, "share", NULL);
  package_locale_dir = g_build_filename (package_prefix, "share", "locale", NULL);
#endif

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, package_locale_dir);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

#ifdef _MSC_VER
  setlocale(LC_ALL,"Japanese");
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  pixmap_dir = g_build_filename (package_data_dir, PACKAGE, "pixmaps", NULL);
  add_pixmap_directory (pixmap_dir);
  g_free (pixmap_dir);


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  
  windrv_setup = create_windrv_setup ();
  gtk_widget_show (windrv_setup);
  g_signal_connect ((gpointer) windrv_setup, "destroy", G_CALLBACK(gtk_main_quit),
                    NULL);

  timidity_cfg_path[0]='\0';
  if(argc >=2 ) strncpy(timidity_cfg_path,argv[1],FILENAME_MAX-1);
  gtk_window_set_title(GTK_WINDOW(windrv_setup),get_cfg_path());

  gtk_main ();

#ifdef G_OS_WIN32
  g_free (package_prefix);
  g_free (package_data_dir);
  g_free (package_locale_dir);
#endif

  return 0;
}
#ifdef _MSC_VER
#include <windows.h>

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{ 
  return main (__argc, __argv);
}
#endif

