/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

#include <windows.h> //for BOOL
#include "file_io.h"

#ifdef G_OS_WIN32
gchar *package_prefix = PACKAGE_PREFIX;
gchar *package_data_dir = PACKAGE_DATA_DIR;
gchar *package_locale_dir = PACKAGE_LOCALE_DIR;
#endif

GtkWidget *entry1;
GtkWidget *entry2;
GtkWidget *output_device_lbl;
GtkWidget *comboboxentry1;

GtkWidget *textview4, *textview3, *textview2, *textview5 ;
GtkTextTagTable *dir_table, *sf2_sel_table, *sf2_table, *cfg_table,
                *other_table, *other_syntax_table;
GtkTextBuffer *dir_buffer, *sf2_sel_buffer, *sf2_buffer, *cfg_buffer,
              *other_buffer, *other_syntax_buffer;
GtkTextIter dir_iter, sf2_sel_iter, sf2_iter, cfg_iter;
GtkWidget *cfg_edit_dlg;
GtkWidget *dir_select_dlg;

#define DROP_TEXT_URI_LIST  10
#define DROP_TEXT_X_MOZ_URL 20
#define DROP_NETSCAPE_URL   30
#define DROP_TEXT_HTML      40
#define DROP_TEXT_PLAIN     50

static GtkTargetEntry drop_targets[] = {
  /*
  { "STRING", GTK_TARGET_SAME_APP, 0 },
  { "BINARY", GTK_TARGET_SAME_WIDGET, 0 },
  */
  { "text/uri-list",  0, DROP_TEXT_URI_LIST },
  { "text/x-moz-url", 0, DROP_TEXT_X_MOZ_URL },
  { "_NETSCAPE_URL_", 0, DROP_NETSCAPE_URL },
  { "text/html",      0, DROP_TEXT_HTML },
  { "text/plain",     0, DROP_TEXT_PLAIN }
};


char timidity_cfg_path[FILENAME_MAX];

int
main (int argc, char *argv[])
{
  GtkWidget *windrv_setup;
  

  gchar *pixmap_dir;
#ifdef G_OS_WIN32
  package_prefix = g_win32_get_package_installation_directory (NULL, NULL);
  package_data_dir = g_build_filename (package_prefix, "share", NULL);
  package_locale_dir = g_build_filename (package_prefix, "share", "locale", NULL);
#endif

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, package_locale_dir);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  pixmap_dir = g_build_filename (package_data_dir, PACKAGE, "pixmaps", NULL);
  add_pixmap_directory (pixmap_dir);
  g_free (pixmap_dir);


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  windrv_setup = create_windrv_setup ();
  dir_select_dlg = create_dir_select_dlg ();
  cfg_edit_dlg = create_cfg_windows ();
  gtk_widget_show (windrv_setup);
  g_signal_connect ((gpointer) windrv_setup, "destroy", G_CALLBACK(gtk_main_quit),
                    NULL);
  
  gtk_entry_set_editable(GTK_ENTRY(entry1), FALSE);
  dir_buffer = gtk_text_buffer_new(dir_table);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(dir_buffer), &dir_iter, 0);
  gtk_text_view_set_buffer(GTK_TEXT_VIEW(textview4), GTK_TEXT_BUFFER(dir_buffer));
  sf2_sel_buffer = gtk_text_buffer_new(sf2_sel_table);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_sel_buffer), &sf2_sel_iter, 0);
  gtk_text_view_set_buffer(GTK_TEXT_VIEW(textview3), GTK_TEXT_BUFFER(sf2_sel_buffer));
  sf2_buffer = gtk_text_buffer_new(sf2_table);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, 0);
  gtk_text_view_set_buffer(GTK_TEXT_VIEW(textview2), GTK_TEXT_BUFFER(sf2_buffer));
  cfg_buffer = gtk_text_buffer_new(cfg_table);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(cfg_buffer), &cfg_iter, 0);
  gtk_text_view_set_buffer(GTK_TEXT_VIEW(textview5), GTK_TEXT_BUFFER(cfg_buffer));
  other_buffer = gtk_text_buffer_new(other_table);
  other_syntax_buffer = gtk_text_buffer_new(other_syntax_table);
  gtk_drag_dest_set(textview4,
		    GTK_DEST_DEFAULT_ALL,
		    drop_targets,
		    sizeof(drop_targets) / sizeof(drop_targets[0]),
		    GDK_ACTION_COPY);
  gtk_drag_dest_set(textview3,
		    GTK_DEST_DEFAULT_ALL,
		    drop_targets,
		    sizeof(drop_targets) / sizeof(drop_targets[0]),
		    GDK_ACTION_COPY);  
  gtk_drag_dest_set(textview2,
		    GTK_DEST_DEFAULT_ALL,
		    drop_targets,
		    sizeof(drop_targets) / sizeof(drop_targets[0]),
		    GDK_ACTION_COPY);  

  timidity_cfg_path[0]='\0';
  if(argc >=2 ) strncpy(timidity_cfg_path,argv[1],FILENAME_MAX-1);
  gtk_window_set_title(GTK_WINDOW(windrv_setup),get_cfg_path());
  readconfig_buffer();
  set_device_list();

  gtk_main ();

#ifdef G_OS_WIN32
  g_free (package_prefix);
  g_free (package_data_dir);
  g_free (package_locale_dir);
#endif

  return 0;
}
#ifdef _MSC_VER
#include <windows.h>

int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{
  return main (__argc, __argv);
}
#endif

