#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gtk/gtk.h>

#include <string.h>
#include <regex.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "file_io.h"

#define my_iter_line_star(a)  gtk_text_iter_backward_chars((a),gtk_text_iter_get_line_offset (a))

gdouble latency= -1;
gchar out_device_c='d';

void cr_add_buffer(GtkTextBuffer *buffer)
{
  gchar *buf;
  GtkTextIter s_iter,e_iter;

  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer),&e_iter);
  s_iter=e_iter;
  gtk_text_iter_backward_word_start(&s_iter);
 buf = gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &s_iter, &e_iter, TRUE);
 if( buf[strlen(buf)-1] != '\n'){
 	gtk_text_iter_forward_to_line_end( &s_iter);
    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer),&s_iter,"\n",strlen("\n"));
  }
  g_free(buf);
}


gchar *getline_buffer(GtkTextBuffer *buffer, gint line_number)
{  
  GtkTextIter sl_iter,el_iter;
  gchar *line;

  cr_add_buffer(buffer);

  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer),&sl_iter,line_number);
  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer),&el_iter,line_number+1);

  line=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &sl_iter, &el_iter, FALSE);
  return line;
}
gint search_buffer(const GtkTextBuffer *buffer, const char *key, gboolean forward)
{
  gint i, offset, linen, fline;
  GtkTextIter s_iter,e_iter;
  gchar *text, *p, *cp;
  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer),&s_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer),&e_iter);
  text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &s_iter, &e_iter, TRUE);
  if ( (p=strstr(text,key)) == NULL){ g_free(text); return -1;}
  if ( forward != TRUE) {
    cp = p;
    while( (cp=strstr(cp,key))!=NULL ){ p=cp; };  
  }
  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(buffer));
  for( i = -1,cp=text; (i < linen-1) && (p > cp); i++)
  	   cp=strstr(cp,"\n");
   g_free(text);
   return i;
}
  
void update_sf2_sel_buffer(void)
{

gint linen, i, offset;
GtkTextIter sl_iter, el_iter, sl_sf2_iter, el_sf2_iter;
gchar buf[2048],buf2[256];
gchar *line_text;
GtkTextIter iter;

//offset=gtk_text_iter_get_offset(&sf2_sel_iter);

buf[0] = '\0';

gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_sel_buffer),&sl_sf2_iter,0);
gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_sel_buffer), &el_sf2_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_sel_buffer),&sl_sf2_iter,&el_sf2_iter);

linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(dir_buffer));
for( i = 0; (i < linen); i++){
  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(dir_buffer),&sl_iter,i);
  el_iter=sl_iter;
  gtk_text_iter_forward_line(&el_iter);
  line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(dir_buffer), 
        &sl_iter, &el_iter, TRUE);
  strcpy(buf2,line_text);
  g_free(line_text);
  if (buf2[0]=='\"') strcpy(buf2,buf2+1);
  if (buf2[strlen(buf2)-1]='\n') buf2[strlen(buf2)-1]='\0' ;
  if (buf2[strlen(buf2)-1]='\"') buf2[strlen(buf2)-1]='\0' ;
  dir_list(buf2,".sf2", buf+strlen(buf), 2048-strlen(buf));
  dir_list(buf2,".cfg", buf+strlen(buf), 2048-strlen(buf));
}
gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_sel_buffer), &iter);
gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), &iter);
if (buf[0] != '\0')
 gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), buf, strlen(buf));
//gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), "\n", strlen("\n"));

//gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_sel_buffer), &sf2_sel_iter, offset);

}

void clear_buffer(GtkTextBuffer *buffer)
{
  GtkTextIter s_iter, e_iter, iter;

  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer), &s_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &e_iter);
  gtk_text_buffer_delete(GTK_TEXT_BUFFER(buffer), &s_iter, &e_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &iter);
  gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(buffer), &iter);
}

void update_cfg_buffer(void)
{
  gint i, linen;
  GtkTextIter s_iter, e_iter, iter;
  gchar *buf, *buf3;
  gchar buf2[128];

  clear_buffer(GTK_TEXT_BUFFER(cfg_buffer));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(dir_buffer));
  for(i=0 ; i< linen; i++){
    buf = getline_buffer(GTK_TEXT_BUFFER(dir_buffer), i);
    if( buf[0] !='\0'){
     sprintf(buf2, "dir %s", buf);    
     gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
    }
    g_free(buf);
  }
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), "\n", strlen("\n"));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(sf2_buffer));
  for(i=0 ; i< linen; i++){
    if( NULL != (buf = getline_buffer(GTK_TEXT_BUFFER(sf2_buffer), i)) ){
 	if (NULL != strstr(buf,".cfg")){
      sprintf(buf2, "source %s", buf);    
      buf3=strdup(buf2);    
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf3, strlen(buf3));
      g_free(buf3);
	}
	if (NULL != strstr(buf,".sf2")){
      sprintf(buf2, "soundfont %s", buf);    
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
    }
    g_free(buf);
    }
  }
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), "\n", strlen("\n"));

  if(latency !=-1){
  	 sprintf(buf2, "#extension opt --rtsyn-latency=%lf\n", latency);
     gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
  }
  sprintf(buf2, "#extension opt --output-mode -O%c\n", out_device_c);
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));

  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer),
      "#extension opt -U\n", strlen("#extension opt -U\n"));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(other_buffer));
  for(i=0 ; i< linen; i++){
    buf = getline_buffer(GTK_TEXT_BUFFER(other_buffer), i);
    if( NULL == strstr( buf, "#extension opt -U"))    
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf, strlen(buf));
    g_free(buf);
  }  	
}

gint saveconfig_buffer(void)
{
  FILE *fp;
  gchar buf[256];
  gchar *linebuf;
  gint linen, i;

  update_cfg_buffer();
  if((fp = fopen(get_cfg_path(), "w"))==NULL) return -1;
  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(cfg_buffer));
  for(i=0 ; i< linen; i++){  
    linebuf = getline_buffer(GTK_TEXT_BUFFER(cfg_buffer),i);
    strncpy(buf, linebuf, 256);
    buf[256-1]='\0';
    g_free(linebuf);
    fprintf(fp,"%s",buf);
  }
  fclose(fp);
  return 0;
}

void rmstr_string(gchar *str, gchar *key)
{
    gchar *cp;
    cp=str;
 	while ((cp=strstr(cp, key) ) !=NULL){
	  strcpy( cp, cp+strlen(key));
	}
}

void update_out_buttons(void){
  const char *buf;
  if (out_device_c == 'd') buf=_("Output Device is now Windows MME");
  if (out_device_c == 'p') buf=_("Output Device is now Portaudio windows MME");
  if (out_device_c == 'P') buf=_("Output Device is now Portaudio Direct Sound");
  if (out_device_c == 'o') buf=_("Output Device is now Portaudio ASIO");  
  gtk_label_set_text(GTK_LABEL(output_device_lbl), buf);
};


gint readconfig_buffer(void)
{
  FILE *fp;
  gchar buf[256];
  gchar *cp;
  gboolean parsed;

  clear_buffer(GTK_TEXT_BUFFER(dir_buffer));
  clear_buffer(GTK_TEXT_BUFFER(sf2_buffer));
  clear_buffer(GTK_TEXT_BUFFER(other_buffer));

  if((fp = fopen(get_cfg_path(), "r"))==NULL) return -1;
  while( NULL != fgets(buf,256,fp) ){
    buf[256-1]='\0';
    if( *(buf+strlen(buf)-1) != '\n' ) strcat(buf,"\n");
    parsed = FALSE;
	if ( strncmp(buf, "dir ", strlen("dir ")) == 0){
      rmstr_string(buf, "dir ");
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), buf, strlen(buf));
      parsed = TRUE;
	}
	if ( strncmp(buf, "source ", strlen("source ")) == 0){
      rmstr_string(buf, "source ");
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf, strlen(buf));
      parsed = TRUE;
	}
	if ( strncmp(buf, "soundfont ", strlen("soundfont ")) == 0){
      rmstr_string(buf, "soundfont ");
      if ( (cp = strstr( buf, ".sf2")) != NULL ){
        gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf, strlen(buf));
        parsed = TRUE;
      }
    }

	if ((cp = strstr(buf, "#extension opt "))!=NULL){    
	  if ((cp = strstr(buf, "--rtsyn-latency="))!=NULL){
        if( sscanf(cp+strlen("--rtsyn-latency="), "%lf", &latency) != EOF )
          parsed = TRUE;
      }else{
	  	if ((cp = strstr(buf, "--output-mode -O"))!=NULL){
          if( sscanf(cp+strlen("--output-mode -O"), "%c", &out_device_c) != EOF )
            parsed = TRUE;
        }else{
          gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(other_buffer), buf, strlen(buf));
          parsed = TRUE;
        }
      }
    }
  };
  update_sf2_sel_buffer();
  update_cfg_buffer();
  if ( latency != -1){
    sprintf(buf, "%lf",latency);
    gtk_entry_set_text(GTK_ENTRY(entry2),buf);
  }
  update_out_buttons();
  fclose(fp);
  return 0;
}


 
void
on_entry1_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_button1_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_show (dir_select_dlg);
}


void
on_textview4_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview4_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview4_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&dir_iter,buffer_x,buffer_y);
my_iter_line_star(&dir_iter);
gtk_text_buffer_set_modified (dir_buffer, FALSE);
  return FALSE;
}


void
on_dir_add_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{

const gchar* name;
GtkTextIter iter, sl_iter, el_iter;
gint linen;
gint i;
gboolean included;
gchar *line_text;
gchar offset;
gchar buf[256];

//offset=gtk_text_iter_get_offset(&dir_iter);

name = gtk_entry_get_text(GTK_ENTRY(entry1));
sprintf(buf,"\"%s\"",name);

included = FALSE;
cr_add_buffer(GTK_TEXT_BUFFER(dir_buffer));
linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(dir_buffer));
for( i = 0; (i < linen) && (included == FALSE) ; i++){
  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(dir_buffer),&sl_iter,i);
  el_iter=sl_iter;
  gtk_text_iter_forward_line(&el_iter);
  line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(dir_buffer), 
        &sl_iter, &el_iter, TRUE);
  line_text[strlen(line_text)-1]='\0';
  if (NULL != strstr(line_text, name)) included = TRUE;
  g_free(line_text);
}
if (included == FALSE){
   gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(dir_buffer), &iter);
   gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(dir_buffer), &iter);
   gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), buf, strlen(buf));
   gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), "\n", strlen("\n"));
}
update_sf2_sel_buffer();
update_cfg_buffer();
//gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(dir_buffer), &dir_iter, offset);
}


void
on_dir_remove_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter sl_iter, el_iter;
gint offset;
gboolean removed;

if (gtk_text_buffer_get_modified (dir_buffer) == TRUE) return;

//offset=gtk_text_iter_get_offset(&dir_iter);
sl_iter=dir_iter;
el_iter=dir_iter;
gtk_text_iter_forward_line(&el_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(dir_buffer),&sl_iter,&el_iter);
update_sf2_sel_buffer();
//gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(dir_buffer), &dir_iter, offset);
update_cfg_buffer();
}


void
on_textview2_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview2_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview2_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&sf2_iter,buffer_x,buffer_y);
my_iter_line_star(&sf2_iter);
gtk_text_buffer_set_modified (sf2_buffer, FALSE);
  return FALSE;
}


void
on_sf2_add_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter iter, sl_iter, el_iter;
gchar *line_text;
gchar buf[258];

if (gtk_text_buffer_get_modified (sf2_sel_buffer) == TRUE) return;

el_iter=sf2_sel_iter;
gtk_text_iter_forward_line(&el_iter);
sl_iter=el_iter;
gtk_text_iter_backward_line(&sl_iter);
line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_sel_buffer), 
        &sl_iter, &el_iter, TRUE);
line_text[strlen(line_text)-1]='\0';
sprintf(buf,"\"%s\"",line_text);
cr_add_buffer(GTK_TEXT_BUFFER(sf2_buffer));
if ( -1 == search_buffer((const GtkTextBuffer *)sf2_buffer,(const char *)line_text, TRUE)){
 gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_buffer), &iter);
 gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &iter);
 gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf, strlen(buf));
 gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), "\n", strlen("\n"));
} 
g_free(line_text);
update_cfg_buffer();
}


void
on_sf2_remove_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter sl_iter, el_iter, bk_iter;
gchar *line_text;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

el_iter=sf2_iter;
gtk_text_iter_forward_line(&el_iter);
sl_iter=el_iter;
gtk_text_iter_backward_line(&sl_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
update_cfg_buffer();
}


void
on_sf2_up_pressed                      (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter to_iter, sl_iter, el_iter;
gchar *line_text;
gint offset;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

sl_iter=sf2_iter;
el_iter=sf2_iter;
gtk_text_iter_forward_line(&el_iter);
if (gtk_text_iter_is_start(&sl_iter) == TRUE ) return; 
to_iter = sf2_iter;
gtk_text_iter_backward_line(&to_iter);
offset=gtk_text_iter_get_offset(&to_iter);
line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_buffer), 
        &sl_iter, &el_iter, TRUE);
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sl_iter, offset);
gtk_text_iter_forward_line(&sl_iter);
el_iter=sl_iter;
gtk_text_iter_forward_line(&el_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &to_iter, offset);
gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &to_iter);
gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), line_text, strlen(line_text));
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
gtk_text_buffer_set_modified (sf2_buffer, FALSE);
g_free(line_text);
update_cfg_buffer();
}


void
on_sf2_down_pressed                    (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter to_iter, sl_iter, el_iter;
gchar *line_text;
gint offset;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

offset=gtk_text_iter_get_offset(&sf2_iter);

sl_iter=sf2_iter;
el_iter=sf2_iter;
if (gtk_text_iter_forward_line(&el_iter) == TRUE ){
  to_iter=el_iter;
  gtk_text_iter_forward_line(&to_iter);
  line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_buffer), 
        &sl_iter, &el_iter, TRUE);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &to_iter, offset);
  gtk_text_iter_forward_lines(&to_iter,2);
  gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &to_iter);
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), line_text, strlen(line_text));
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sl_iter, offset);
  el_iter=sl_iter;  
  gtk_text_iter_forward_line(&el_iter);
  gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
  g_free(line_text);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
  gtk_text_buffer_set_modified (sf2_buffer, FALSE);
  gtk_text_iter_forward_line(&sf2_iter);
}else{
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
  gtk_text_buffer_set_modified (sf2_buffer, FALSE);
}
update_cfg_buffer();
}


void
on_textview3_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview3_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview3_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&sf2_sel_iter,buffer_x,buffer_y);
my_iter_line_star(&sf2_sel_iter);
gtk_text_buffer_set_modified (sf2_sel_buffer, FALSE);
  return FALSE;
}


void
on_entry2_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
const gchar *inbuf;
inbuf=gtk_entry_get_text(GTK_ENTRY(editable));
if (0==sscanf(inbuf,"%lf",&latency) ) latency=-1.0;
update_cfg_buffer();
}


void
on_button15_pressed                    (GtkButton       *button,
                                        gpointer         user_data)
{
asioConfigDialog();

}


void
on_discard_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{
readconfig_buffer();
update_cfg_buffer();
}


void
on_cacel_quit_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_main_quit(); 
}


void
on_quit_pressed                        (GtkButton       *button,
                                        gpointer         user_data)
{
saveconfig_buffer();
gtk_main_quit(); 
}


void
on_dir_select_cancel_btn_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(dir_select_dlg);
}


void
on_dir_select_open_btn_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *dir_name;
  gtk_widget_hide(dir_select_dlg);
  dir_name = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (dir_select_dlg));
  gtk_entry_set_editable(GTK_ENTRY(entry1), TRUE);
  gtk_entry_set_text(GTK_ENTRY(entry1),(const gchar *)dir_name);
  gtk_entry_set_editable(GTK_ENTRY(entry1), FALSE);
  g_free(dir_name);
}


void
on_out_pa_win_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
out_device_c='p';
update_out_buttons();
update_cfg_buffer();
}


void
on_out_pa_directx_btn_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
out_device_c='P';
update_out_buttons();
update_cfg_buffer();
}


void
on_out_pa_asio_btn_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
out_device_c='o';
update_out_buttons();
update_cfg_buffer();
}


void
on_cfg_window_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
update_cfg_buffer();
gtk_widget_show (cfg_edit_dlg);
}


void
on_out_winmm_btn_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
out_device_c='d';
update_out_buttons();
update_cfg_buffer();
}


void
on_dir_select_dlg_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
gtk_widget_hide (dir_select_dlg);
}


gboolean
on_dir_select_dlg_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_hide (dir_select_dlg);
  return TRUE;
}


void
on_cfg_windows_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
gtk_widget_hide (cfg_edit_dlg);
}


gboolean
on_cfg_windows_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_hide (cfg_edit_dlg);
  return TRUE;
}

