/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/
/*  timiditydrv.cpp  this codes are imported from MT-32 Emulator source. 
    MT-32 Emulator is a "Public Domain" MIDI rendering engine. 
 */

// timiditydrv.cpp : Implementation of DLL Exports.


// Note: Proxy/Stub Information
//      To build a separate proxy/stub DLL, 
//      run nmake -f timiditydrvps.mk in the project directory.

#include "stdafx.h"
#include "resource.h"
#include <initguid.h>
#include "timiditydrv.h"

#include "ks.h"
#include "dmusics.h"
#include <dmusici.h>
#include "mmddk.h"
#include <mmsystem.h>
#if 0 
typedef struct tagMIDIOUTCAPS2A {
    WORD    wMid;                  /* manufacturer ID */
    WORD    wPid;                  /* product ID */
    MMVERSION vDriverVersion;      /* version of the driver */
    CHAR    szPname[MAXPNAMELEN];  /* product name (NULL terminated string) */
    WORD    wTechnology;           /* type of device */
    WORD    wVoices;               /* # of voices (internal synth only) */
    WORD    wNotes;                /* max # of notes (internal synth only) */
    WORD    wChannelMask;          /* channels used (internal synth only) */
    DWORD   dwSupport;             /* functionality supported by driver */
    GUID    ManufacturerGuid;      /* for extensible MID mapping */
    GUID    ProductGuid;           /* for extensible PID mapping */
    GUID    NameGuid;              /* for name lookup in registry */
} MIDIOUTCAPS2A, *PMIDIOUTCAPS2A, *NPMIDIOUTCAPS2A, *LPMIDIOUTCAPS2A;
typedef struct tagMIDIOUTCAPS2W {
    WORD    wMid;                  /* manufacturer ID */
    WORD    wPid;                  /* product ID */
    MMVERSION vDriverVersion;      /* version of the driver */
    WCHAR   szPname[MAXPNAMELEN];  /* product name (NULL terminated string) */
    WORD    wTechnology;           /* type of device */
    WORD    wVoices;               /* # of voices (internal synth only) */
    WORD    wNotes;                /* max # of notes (internal synth only) */
    WORD    wChannelMask;          /* channels used (internal synth only) */
    DWORD   dwSupport;             /* functionality supported by driver */
    GUID    ManufacturerGuid;      /* for extensible MID mapping */
    GUID    ProductGuid;           /* for extensible PID mapping */
    GUID    NameGuid;              /* for name lookup in registry */
} MIDIOUTCAPS2W, *PMIDIOUTCAPS2W, *NPMIDIOUTCAPS2W, *LPMIDIOUTCAPS2W;
#ifdef UNICODE
typedef MIDIOUTCAPS2W MIDIOUTCAPS2;
typedef PMIDIOUTCAPS2W PMIDIOUTCAPS2;
typedef NPMIDIOUTCAPS2W NPMIDIOUTCAPS2;
typedef LPMIDIOUTCAPS2W LPMIDIOUTCAPS2;
#else
typedef MIDIOUTCAPS2A MIDIOUTCAPS2;
typedef PMIDIOUTCAPS2A PMIDIOUTCAPS2;
typedef NPMIDIOUTCAPS2A NPMIDIOUTCAPS2;
typedef LPMIDIOUTCAPS2A LPMIDIOUTCAPS2;
#endif // UNICODE
#endif 
#include "timiditydrv_i.c"
#include "tim_synth.h"

#include "stdio.h"
#include "SynthClassFactory.h"

#include <mmreg.h>

HRESULT RegisterSynth(REFGUID guid, const char szDescription[]);

const char cszSynthRegRoot[] = REGSTR_PATH_SOFTWARESYNTHS "\\";
const char cszDescriptionKey[] = "Description";
const int CLSID_STRING_SIZE = 39;

CComModule _Module;

LONG driverCount;
signed long midiCount;
HINSTANCE myInstance;

FILE *logfile;

BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_tim_synth, tim_synth)
OBJECT_ENTRY(CLSID_SynthClassFactory, SynthClassFactory)
END_OBJECT_MAP()

/////////////////////////////////////////////////////////////////////////////
// DLL Entry Point

extern "C"
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{

	myInstance = hInstance;

    if (dwReason == DLL_PROCESS_ATTACH)
    {
        _Module.Init(ObjectMap, hInstance, &LIBID_TIM_DRVLib); 
        DisableThreadLibraryCalls(hInstance);
    }
    else if (dwReason == DLL_PROCESS_DETACH)
        _Module.Term();
    return TRUE;    // ok
}

/////////////////////////////////////////////////////////////////////////////
// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	
	if(IsEqualCLSID(rclsid, CLSID_tim_synth)) {
		SynthClassFactory *pFactory = new SynthClassFactory;
		if(FAILED(pFactory->QueryInterface(riid, ppv))) {
			delete pFactory;
			*ppv = NULL;
			return E_INVALIDARG;
		}
	
		return S_OK;

	} else {
		return _Module.GetClassObject(rclsid, riid, ppv);
	}
}

/////////////////////////////////////////////////////////////////////////////
// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)
{
	RegisterSynth(CLSID_tim_synth, "Timidity++ Driver");
    // registers object, typelib and all interfaces in typelib
    return _Module.RegisterServer(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)
{
    return _Module.UnregisterServer(TRUE);
}


// MMSystem legacy stuff

IDirectMusicPerformance *myPerf = NULL;
IDirectMusic *myDM = NULL;
IDirectMusicPort *myDMPort = NULL;
IDirectMusicBuffer *myDMBuffer = NULL;
IReferenceClock *myLatentClock = NULL;


INT_PTR CALLBACK DialogHandler(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg) {
	case WM_INITDIALOG:
		CheckDlgButton(hwndDlg,IDC_CHECKREVENABLE, BST_CHECKED);
//		if (DetectSIMD()) {
//			SetWindowText((HWND)IDC_SYNTHMETHOD, "Using SIMD for synthesis");
//		} else if (Detect3DNow()) {
//			SetWindowText((HWND)IDC_SYNTHMETHOD, "Using 3DNOW for synthesis");
//		} else {
			SetWindowText((HWND)IDC_SYNTHMETHOD, (const char *)"Using FPU for synthesis");
//		}


		return true;
		break;
	case WM_COMMAND: 
        if (wParam == IDOK) 
        { 
            EndDialog(hwndDlg, TRUE); 
            return TRUE; 
        } 
        return 0; 
	default:
		break;
	}
	return false;
}

STDAPI_(LONG)   DriverProc
(
    DWORD           dwDriverID,
    HANDLE          hDriver,
    WORD            wMessage,
    DWORD           dwParam1,
    DWORD           dwParam2
)
{

#ifdef DEBUG
	logfile = fopen("c:\\dbglog.log","at");
	if(logfile!=NULL) {
		fprintf(logfile,"DriverProc Msg: 0x%x\n", wMessage);
	}
	fclose(logfile);
#endif

	switch(wMessage) {
	case DRV_LOAD:
		driverCount = 0;
		return 0x1;
		break;
	case DRV_ENABLE:
		return 0x1;
		break;
	case DRV_OPEN:
#ifdef DEBUG
		logfile = fopen("c:\\dbglog.log","at");
		if(logfile!=NULL) {
			fprintf(logfile,"DriverProc Enter Sub Open - driverCount = %d\n", driverCount);
		}
		fclose(logfile);
#endif

		driverCount++;
#ifdef DEBUG
		logfile = fopen("c:\\dbglog.log","at");
		if(logfile!=NULL) {
			fprintf(logfile,"DriverProc Open - driverCount = %d\n", driverCount);
		}
		fclose(logfile);
#endif
		return driverCount;
		break;
	case DRV_INSTALL:
		return DRVCNF_OK;
		break;
	case DRV_QUERYCONFIGURE:
		return 1;
		break;
/*	case DRV_CONFIGURE:
		DialogBox(myInstance, (LPCTSTR)IDD_DIALOG1, (HWND)dwParam1,&DialogHandler);
		return DRVCNF_OK;
		break;
*/
	case DRV_CLOSE:

		--driverCount;
		if(driverCount==0) {
			if(myPerf!=NULL) myPerf->CloseDown();
			if(myDM!=NULL) myDM->Release();
			if(myPerf!=NULL) myPerf->Release();

			CoUninitialize();
		}

		return (driverCount+1);
		break;
	case DRV_DISABLE:
		return 0x1;
		break;
	case DRV_FREE:
		return 0x1;
		break;
	case DRV_REMOVE:
		// To do; Implement removal of DLL registry
		return 0x1;
		break;
	case 0x80b:
		// Just incase
		RegisterSynth(CLSID_tim_synth, "Timidity++ Driver");
		_Module.RegisterServer(TRUE);
	default:
		return 0x1;
		break;
	}
	return 0x1;
}

HRESULT modGetCaps(PVOID capsPtr, DWORD capsSize) {
	MIDIOUTCAPSA * myCapsA;
	MIDIOUTCAPSW * myCapsW;
	MIDIOUTCAPS2A * myCaps2A;
	MIDIOUTCAPS2W * myCaps2W;

	CHAR synthName[] = "Timidity++ Driver\0";
	WCHAR synthNameW[] = L"Timidity++ Driver\0";

#ifdef DEBUG
	logfile = fopen("c:\\dbglog.log","at");
	if(logfile!=NULL) {
#ifdef UNICODE
		fprintf(logfile,"In Unicode");
#endif
		fprintf(logfile,"modMessage GetDevCaps: size %d, caps1 %d caps2 %d\n", capsSize, sizeof(MIDIOUTCAPS), sizeof(MIDIOUTCAPS2));
	}
	fclose(logfile);
#endif

	
	switch (capsSize) {
	case (sizeof(MIDIOUTCAPSA)):
		myCapsA = (MIDIOUTCAPSA *)capsPtr;
		myCapsA->wMid = MM_UNMAPPED;
		myCapsA->wPid = MM_MPU401_MIDIOUT;
		memcpy(myCapsA->szPname, synthName, sizeof(synthName));
		myCapsA->wTechnology = MOD_MIDIPORT;
		myCapsA->vDriverVersion = 0x0090;
		myCapsA->wVoices = 0;
		myCapsA->wNotes = 0;
		myCapsA->wChannelMask = 0xffff;
		myCapsA->dwSupport = 0;
		return MMSYSERR_NOERROR;

		break;
	case (sizeof(MIDIOUTCAPSW)):
		myCapsW = (MIDIOUTCAPSW *)capsPtr;
		myCapsW->wMid = MM_UNMAPPED;
		myCapsW->wPid = MM_MPU401_MIDIOUT;
		memcpy(myCapsW->szPname, synthNameW, sizeof(synthNameW));
		myCapsW->wTechnology = MOD_MIDIPORT;
		myCapsW->vDriverVersion = 0x0090;
		myCapsW->wVoices = 0;
		myCapsW->wNotes = 0;
		myCapsW->wChannelMask = 0xffff;
		myCapsW->dwSupport = 0;
		return MMSYSERR_NOERROR;

		break;
	case (sizeof(MIDIOUTCAPS2A)):
		myCaps2A = (MIDIOUTCAPS2A *)capsPtr;
		myCaps2A->wMid = MM_UNMAPPED;
		myCaps2A->wPid = MM_MPU401_MIDIOUT;
		memcpy(myCaps2A->szPname, synthName, sizeof(synthName));
		myCaps2A->wTechnology = MOD_MIDIPORT;
		myCaps2A->vDriverVersion = 0x0090;
		myCaps2A->wVoices = 0;
		myCaps2A->wNotes = 0;
		myCaps2A->wChannelMask = 0xffff;
		myCaps2A->dwSupport = 0;
		myCaps2A->ManufacturerGuid = CLSID_SynthClassFactory;
		myCaps2A->ProductGuid = CLSID_tim_synth;
		myCaps2A->NameGuid = CLSID_tim_synth;
		return MMSYSERR_NOERROR;

	case (sizeof(MIDIOUTCAPS2W)):
		myCaps2W = (MIDIOUTCAPS2W *)capsPtr;
		myCaps2W->wMid = MM_UNMAPPED;
		myCaps2W->wPid = MM_MPU401_MIDIOUT;
		memcpy(myCaps2W->szPname, synthNameW, sizeof(synthNameW));
		myCaps2W->wTechnology = MOD_MIDIPORT;
		myCaps2W->vDriverVersion = 0x0090;
		myCaps2W->wVoices = 0;
		myCaps2W->wNotes = 0;
		myCaps2W->wChannelMask = 0xffff;
		myCaps2W->dwSupport = 0;
		myCaps2W->ManufacturerGuid = CLSID_SynthClassFactory;
		myCaps2W->ProductGuid = CLSID_tim_synth;
		myCaps2W->NameGuid = CLSID_tim_synth;
		return MMSYSERR_NOERROR;

	default:
		return MMSYSERR_ERROR;

		break;
	}

}

void WriteLog(const char * charMsg, unsigned int uMsg)
{
#ifdef DEBUG
	logfile = fopen("c:\\dbglog.log","at");
	if(logfile!=NULL) {
		fprintf(logfile,"modMessage '%s' Msg: 0x%x\n", charMsg, uMsg);
	}
	fclose(logfile);
#endif
}

STDAPI_(LONG) modMessage(UINT uDeviceID, UINT uMsg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{

	REFERENCE_TIME rt;
	LPBYTE ppData;
	MIDIHDR * midiHdr;
	HRESULT ntStatus;
	
	switch (uMsg) {
	case MODM_OPEN:
		if((midiCount==0) || (myDMPort==NULL)) {
			DMUS_PORTPARAMS dummyParms;
			memset(&dummyParms,0,sizeof(dummyParms));
			dummyParms.dwSize = sizeof(DMUS_PORTPARAMS);
			
			DMUS_BUFFERDESC dummyBuffer;
			dummyBuffer.dwSize = sizeof(DMUS_BUFFERDESC);
			dummyBuffer.dwFlags = 0;
			dummyBuffer.guidBufferFormat = GUID_NULL;
			dummyBuffer.cbBuffer = 2048;
 
			// Haha, this is a hack and a half.  Rather than interface with our stuff
			// directly, I'm using the DirectMusic interface to conveniently save myself
			// a lot of code.
			if(myPerf==NULL) {
				CoInitialize(NULL);
				HRESULT ntStatus;
				ntStatus = CoCreateInstance(CLSID_DirectMusicPerformance, NULL, CLSCTX_INPROC, IID_IDirectMusicPerformance8, (void**)&myPerf);
				if(myPerf==NULL) {
#ifdef DEBUG
					logfile = fopen("c:\\dbglog.log","at");
					if(logfile!=NULL) {
						fprintf(logfile,"Midi Open - failed initializing myPerf Error 0x%x\n", ntStatus);
					}
					fclose(logfile);
#endif
					CoUninitialize();
					return MMSYSERR_ERROR;
				}
			}
			myPerf->Init(&myDM, NULL, NULL);
	
			if(myDM==NULL) return MMSYSERR_ERROR;
			ntStatus = myDM->CreatePort(CLSID_tim_synth, &dummyParms, &myDMPort, NULL);
			if(myDMPort==NULL) return MMSYSERR_ERROR;
			myDM->CreateMusicBuffer(&dummyBuffer, &myDMBuffer, NULL);
			if(myDMBuffer==NULL) return MMSYSERR_ERROR;
			myDMPort->Activate(true);
			WriteLog("Successful opening of mmSystem Timidity",uMsg);
		} else {
			WriteLog("Attempt to open after already open",uMsg);
		}
		
		midiCount++;
		*(LONG *)dwUser = midiCount;
		return MMSYSERR_NOERROR;
		break;
	case MODM_PREPARE:
		return MMSYSERR_NOTSUPPORTED;
		break;
	case MODM_UNPREPARE:
		return MMSYSERR_NOTSUPPORTED;
		break;
	case MODM_GETDEVCAPS:
		WriteLog("Query of device caps",uMsg);
		return modGetCaps((PVOID)dwParam1, dwParam2);
		break;
	case MODM_DATA:
		WriteLog("Timidity sent data",dwParam1);
		myDMBuffer->Flush();
		myDMPort->GetLatencyClock(&myLatentClock);
		myLatentClock->GetTime(&rt);
		myDMBuffer->PackStructured(rt, 1, dwParam1);
		myDMBuffer->GetRawBufferPtr(&ppData);
		myDMPort->PlayBuffer((LPDIRECTMUSICBUFFER)myDMBuffer);

		return MMSYSERR_NOERROR;
		break;
	case MODM_LONGDATA:
		
		myDMBuffer->Flush();
		myDMPort->GetLatencyClock(&myLatentClock);
		myLatentClock->GetTime(&rt);
		midiHdr = (MIDIHDR *)dwParam1;
		WriteLog("Timidity sent longdata",midiHdr->dwBufferLength);
		myDMBuffer->PackUnstructured(rt, 1, midiHdr->dwBufferLength, (unsigned char *)midiHdr->lpData);
		myDMBuffer->GetRawBufferPtr(&ppData);
		myDMPort->PlayBuffer((LPDIRECTMUSICBUFFER)myDMBuffer);
		midiHdr->dwFlags = MHDR_DONE;

		return MMSYSERR_NOERROR;
		break;
	case MODM_GETNUMDEVS:
		return 0x1;
		break;
	case MODM_CLOSE:

		--midiCount;
		if(midiCount<=0) {
			WriteLog("Close with deinitialization",uMsg);
			if(myDMPort!=NULL) myDMPort->Activate(false);
			if(myDMBuffer!=NULL) myDMBuffer->Release();
			if(myDMPort!=NULL) myDMPort->Release();


		} else {
			WriteLog("Close without deinitialization",uMsg);

		}
		return MMSYSERR_NOERROR;
		break;
	default:
		WriteLog("Unhandled message",uMsg);
		return MMSYSERR_NOERROR;
		break;
	}


}


HRESULT WriteRegString(HKEY hkey, LPCTSTR valuename, char *useStr) {
	HRESULT hr;
	    hr = S_OK;
      if (RegSetValueEx(hkey,
                        valuename,
                        0L,
                        REG_SZ,
                        (const unsigned char *)useStr,
                        strlen((const char *)useStr) + 1))
      {
          hr = E_FAIL;
      }
	return hr;

}

HRESULT RegisterSynth(REFGUID guid,
                        const char szDescription[])
  {
      HKEY hk;
      WCHAR szCLSID[CLSID_STRING_SIZE];
      char szRegKey[256];
	  LPWSTR wsCLS = szCLSID;

	  char callingAllAngels[CLSID_STRING_SIZE+1];


      HRESULT hr = StringFromCLSID(guid, &wsCLS);
      if (!SUCCEEDED(hr))
      {
          return hr;
      }

      strcpy(szRegKey, cszSynthRegRoot);

	  WideCharToMultiByte(CP_ACP, WC_NO_BEST_FIT_CHARS, wsCLS, CLSID_STRING_SIZE, callingAllAngels, CLSID_STRING_SIZE+1, NULL, NULL);

      strcat(szRegKey, callingAllAngels);

      if (RegCreateKey(HKEY_LOCAL_MACHINE,
                       (const char *)szRegKey,
                       &hk))
      {
          return E_FAIL;
      }

      hr = S_OK;
      if (RegSetValueEx(hk,
                        (const char *)cszDescriptionKey,
                        0L,
                        REG_SZ,
                        (const unsigned char *)szDescription,
                        strlen(szDescription) + 1))
      {
          hr = E_FAIL;
      }

      RegCloseKey(hk);


      return hr;
  }
