/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    aRts_a.c by Peter L Jones <peter@drealm.org.uk>
    based on esd_a.c

    Functions to play sound through aRts
*/

#ifndef __CSYNTHTIM_H__
#define __CSYNTHTIM_H___

bool DetectSIMD();
bool Detect3DNow();

class CSynthTIM  {
private:

	unsigned char initmode;
	bool isOpen;
	bool InitTables(char * baseDir);

public:
	CCSynthTIM(void);
//	CSynthTIM() :isOpen(false) {};
	char * GetName(void) { return "mt32";};


	bool ClassicOpen(char * baseDir);
	void Close(void);
	void PlayMsg(unsigned long msg);
	void PlaySysex(unsigned char * sysex,unsigned long len);

	void TIM_CallBack(unsigned char * stream,unsigned long len);

};

#endif