/*
 * copyright postclass.jp 
 */
package jp.postclass.commons.utils;


/**
 * ^Op̃[eBeBNX.
 * 
 * @author ryo
 */
public final class UtilsForTag {

    private static final int WHITE_SPACE = ' ';
    private static final int CR = '\r';
    private static final int LF = '\n';
    private static final int LT = '<';
    private static final int GT = '>';

    public static String trimWhiteSpacesAndNewline(final String outputtedString,
                                                   final boolean trimNewline) {

        final StringBuilder buf = new StringBuilder();

        boolean trim = false;

        for (int i = 0; i < outputtedString.length(); i++) {

            final int codePoint = outputtedString.codePointAt(i);

            if (trim) {
                if (codePoint == WHITE_SPACE) {
                    continue;
                }

                if (trimNewline) {
                    if (codePoint == CR) {
                        continue;
                    }

                    if (codePoint == LF) {
                        continue;
                    }
                }
            }

            buf.appendCodePoint(codePoint);

            if (codePoint == LT) {
                trim = false;
            } else if (codePoint == GT) {
                trim = true;
            }

            if (Character.isHighSurrogate(outputtedString.charAt(i))) {
                i++;
            }
        }

        return buf.toString();
    }
}
