/*
 * copyright postclass.jp 
 */
package jp.postclass.commons.http.filter.trimWhitespaces;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/**
 * ʏHttpServletResponseByteArrayServletResponseI\ȃT[ubgX|X.
 * 
 * @author ryo
 */
public class SelectableServletResponse implements HttpServletResponse {

    private HttpServletResponse response;
    private final HttpServletResponse normalResponse;
    private final ByteArrayServletResponse byteArrayResponse;

    /**
     * ʏ̃T[ubgX|XăCX^X𐶐܂.
     * 
     * @param originalResponse ʏHttpServletResponse
     */
    public SelectableServletResponse(final HttpServletResponse originalResponse) {
        this.normalResponse = originalResponse;
        this.byteArrayResponse =
                new ByteArrayServletResponse(this.normalResponse);
        this.response = this.byteArrayResponse;
    }

    /**
     * ʏHttpServletResponsegp܂.
     */
    public void useNormalResponse() {
        this.response = this.normalResponse;
    }

    /**
     * ByteArrayServletResponsegp܂.
     */
    public void useByteArrayResponse() {
        this.response = this.byteArrayResponse;
    }

    /* ******************************  ****************************** */


    /**
     * @param arg0
     * @see javax.servlet.http.HttpServletResponse#addCookie(javax.servlet.http.Cookie)
     */
    public void addCookie(final Cookie arg0) {
        this.response.addCookie(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addDateHeader(java.lang.String,
     *      long)
     */
    public void addDateHeader(final String arg0, final long arg1) {
        this.response.addDateHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addHeader(java.lang.String,
     *      java.lang.String)
     */
    public void addHeader(final String arg0, final String arg1) {
        this.response.addHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#addIntHeader(java.lang.String,
     *      int)
     */
    public void addIntHeader(final String arg0, final int arg1) {
        this.response.addIntHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#containsHeader(java.lang.String)
     */
    public boolean containsHeader(final String arg0) {
        return this.response.containsHeader(arg0);
    }

    /**
     * @param arg0
     * @return
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectUrl(java.lang.String)
     */
    @Deprecated
    public String encodeRedirectUrl(final String arg0) {
        return this.response.encodeRedirectUrl(arg0);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectURL(java.lang.String)
     */
    public String encodeRedirectURL(final String arg0) {
        return this.response.encodeRedirectURL(arg0);
    }

    /**
     * @param arg0
     * @return
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#encodeUrl(java.lang.String)
     */
    @Deprecated
    public String encodeUrl(final String arg0) {
        return this.response.encodeUrl(arg0);
    }

    /**
     * @param arg0
     * @return
     * @see javax.servlet.http.HttpServletResponse#encodeURL(java.lang.String)
     */
    public String encodeURL(final String arg0) {
        return this.response.encodeURL(arg0);
    }

    /**
     * @throws IOException
     * @see javax.servlet.ServletResponse#flushBuffer()
     */
    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getBufferSize()
     */
    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getCharacterEncoding()
     */
    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getContentType()
     */
    public String getContentType() {
        return this.response.getContentType();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#getLocale()
     */
    public Locale getLocale() {
        return this.response.getLocale();
    }

    /**
     * @return
     * @throws IOException
     * @see javax.servlet.ServletResponse#getOutputStream()
     */
    public ServletOutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    /**
     * @return the response
     */
    public HttpServletResponse getResponse() {
        return this.response;
    }

    /**
     * @return
     * @throws IOException
     * @see javax.servlet.ServletResponse#getWriter()
     */
    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    /**
     * @return
     * @see javax.servlet.ServletResponse#isCommitted()
     */
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    /**
     * 
     * @see javax.servlet.ServletResponse#reset()
     */
    public void reset() {
        this.response.reset();
    }

    /**
     * 
     * @see javax.servlet.ServletResponse#resetBuffer()
     */
    public void resetBuffer() {
        this.response.resetBuffer();
    }

    /**
     * @param arg0
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendError(int)
     */
    public void sendError(final int arg0) throws IOException {
        this.response.sendError(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendError(int,
     *      java.lang.String)
     */
    public void sendError(final int arg0, final String arg1) throws IOException {
        this.response.sendError(arg0, arg1);
    }

    /**
     * @param arg0
     * @throws IOException
     * @see javax.servlet.http.HttpServletResponse#sendRedirect(java.lang.String)
     */
    public void sendRedirect(final String arg0) throws IOException {
        this.response.sendRedirect(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setBufferSize(int)
     */
    public void setBufferSize(final int arg0) {
        this.response.setBufferSize(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setCharacterEncoding(java.lang.String)
     */
    public void setCharacterEncoding(final String arg0) {
        this.response.setCharacterEncoding(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setContentLength(int)
     */
    public void setContentLength(final int arg0) {
        this.response.setContentLength(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setContentType(java.lang.String)
     */
    public void setContentType(final String arg0) {
        this.response.setContentType(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setDateHeader(java.lang.String,
     *      long)
     */
    public void setDateHeader(final String arg0, final long arg1) {
        this.response.setDateHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setHeader(java.lang.String,
     *      java.lang.String)
     */
    public void setHeader(final String arg0, final String arg1) {
        this.response.setHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @param arg1
     * @see javax.servlet.http.HttpServletResponse#setIntHeader(java.lang.String,
     *      int)
     */
    public void setIntHeader(final String arg0, final int arg1) {
        this.response.setIntHeader(arg0, arg1);
    }

    /**
     * @param arg0
     * @see javax.servlet.ServletResponse#setLocale(java.util.Locale)
     */
    public void setLocale(final Locale arg0) {
        this.response.setLocale(arg0);
    }

    /**
     * @param arg0
     * @see javax.servlet.http.HttpServletResponse#setStatus(int)
     */
    public void setStatus(final int arg0) {
        this.response.setStatus(arg0);
    }

    /**
     * @param arg0
     * @param arg1
     * @deprecated
     * @see javax.servlet.http.HttpServletResponse#setStatus(int,
     *      java.lang.String)
     */
    @Deprecated
    public void setStatus(final int arg0, final String arg1) {
        this.response.setStatus(arg0, arg1);
    }

    /**
     * @return the originalResponse
     */
    public HttpServletResponse getOriginalResponse() {
        return this.normalResponse;
    }

    /**
     * @return the poolableResponse
     */
    public ByteArrayServletResponse getPoolableResponse() {
        return this.byteArrayResponse;
    }

}
