package com.limegroup.gnutella.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

import com.limegroup.gnutella.util.CommonUtils;

/** 
 * This class manages the properties needed by the 
 * com.limegroup.gnutella.server.**  package  It maintains
 * default settings for values not set in the saved  
 * settings files.
 *
 * <p>Adheres to Singleton design pattern.
 * So, only one instance of the class gets created.
 *
 * @author Anurag Singla
 */

/**
 * This class has been modified for Acquisition.
 * David Watanabe
 */

public class LimeXMLProperties
{

    /**
     * The default index for responses when there is no there no file and 
     * hecne to no download. The value is set to 2^32 -1
     */
    public static final long DEFAULT_NONFILE_INDEX = 0x00000000FFFFFFFFl;
    
    private static LimeXMLProperties _instance = new LimeXMLProperties();

    /**
     * The name of the directory in which XML Schemas will be 
     * kept for querying and responding.
     */
    private static final String XML_SCHEMA_DIR_DEF = "xml" + File.separator + 
                                                "schemas" + File.separator;

    
    /**
     * The name of the directory in which XML Documents will be 
     * kept for querying and responding.
     */
    private static final String XML_DOCS_DIR_DEF = "xml" + File.separator + 
                                                "data" + File.separator;

    /**
     * The name of the directory in which the field names for various 
     * schemas will have their display strings.
     */
    private static final String XML_DISPLAY_PROPS_DIR_DEF = "xml"+ 
        File.separator+"display"+File.separator;
    
    /**
     * If an instance of this object has been already initialized, returns it, 
     * else initializes
     * a new instance and returns the same
     * @return The initialized instance of this class
     */
    public static LimeXMLProperties instance()
    {
        return _instance;
    }


    //Accessor methods

    /**
     * Returns the name of the directory in which XML Schemas are located
     * for querying and responding.
     */
    public String getXMLSchemaDir() {
        return "xml/schemas/";
    }

    /**
     * Returns the name of the directory where the XML Documents are located
     */
    public String getXMLDocsDir() {
        return System.getProperty("user.home") + "/Library/Application Support/AcqLite/";
    }
    
    /**
     * Returns the files pertaining to the XML Schemas used for 
     * querying/responding
     */
    public File[] getAllXMLSchemaFiles()
    {
        //System.err.println("LimeXMLProperties: getAllXMLSchemaFiles");
    
        File dir = new File(getXMLSchemaDir());
        String[] fileNames = (dir).list(
            new FilenameFilter()
            {
                //the files to be accepted to be returned
                public boolean accept(File dir, String name)
                {
                    if(name.endsWith(".xsd"))
                    {
                        return true;
                    }
                    return false;
                }
            });
        if(fileNames==null || fileNames.length==0)
            return new File[0];
        int z = fileNames.length;
        File[] files = new File[z];
        for(int i=0;i<z;i++){
            files[i]  = new File(dir,fileNames[i]);
        }

        //System.err.println("LimeXMLProperties: getAllXMLSchemaFiles: " + files);
        return files;
    }
    
    /* davew */
    public String getUserMapFile() {
        return null;
    }
}