#import "AqUploadsController.h"
#import "AqUploadsToolbarDelegate.h"


@implementation AqUploadsToolbarDelegate

/* Initialization */

    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; {
        instance = self;
        [self initItems];
    }

    - (void) initItems; 
    {
        [self initSearch];
        [self initDrawer];
        [self initBrowseHost];

        id l,p;
        l = NSLocalizedStringFromTable(@"Reveal", @"UploadsToolbar", @"Reveal action label");
        p = NSLocalizedStringFromTable(@"Reveal in Finder", @"UploadsToolbar", @"Reveal action palette label");
        
        item_reveal = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_reveal"];
            [item_reveal setLabel: l];
            [item_reveal setPaletteLabel: p];
            [item_reveal setAction: @selector(revealSelected:)];
            [item_reveal setImage: [NSImage imageNamed: @"reveal"]];

        l = NSLocalizedStringFromTable(@"Remove", @"UploadsToolbar", @"Remove action label");
        p = NSLocalizedStringFromTable(@"Remove Upload", @"UploadsToolbar", @"Remove action palette label");

        item_cancel = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_cancel"];
            [item_cancel setLabel: l];
            [item_cancel setPaletteLabel: p];
            [item_cancel setAction: @selector(removeSelected:)];
            [item_cancel setImage: [NSImage imageNamed: @"delete"]];
    }
    
    - (id) toolbarIdentifier; {
        return @"AqUploadsToolbarDelegateA";
    }

    
/* Events */

    - (void) selectionIsChanging: (id) theTableView; {
        BOOL somethingIsSelected = [theTableView selectedRow] > -1;
        [item_reveal setTarget: (somethingIsSelected) ? [AqUploadsController instance] : nil];
        [item_cancel setTarget: (somethingIsSelected) ? [AqUploadsController instance] : nil];
        [super selectionIsChanging: theTableView];
    }


/* NSToolbar Delegate */

    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_search",
            NSToolbarSeparatorItemIdentifier, 
            @"item_reveal",
            @"item_cancel",
            NSToolbarSeparatorItemIdentifier, 
            @"item_browsehost",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_cancel",
            @"item_reveal",
            @"item_browsehost",
            @"item_drawer",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }

@end