#import "AqContentViewController.h"
#import "AqQueryDataSource.h"
#import "AqQueryToolbarDelegate.h"
#import "NSMenuExtensions.h"


@implementation AqQueryToolbarDelegate

/* Initialization */

    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; {
        instance = self;
        [self initItems];
    }

    - (id) toolbarIdentifier; {
        return @"AqQueryToolbarDelegateC";
    }


/* Toolbar Item Initialization */
    
    - (void) initItems; 
    {
        [self initSearch];
        [self initDrawer];
        [self initBrowseHost];

        id l,p;
        l = NSLocalizedStringFromTable(@"Filter Results", @"QueryToolbar", @"Filter Results label");
        
        item_filter = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_filter"];
            [item_filter setLabel: l];
            [item_filter setPaletteLabel: l];
            [item_filter setView: filterView];
            [item_filter setMinSize: [filterView frame].size];
            [item_filter setMaxSize: [filterView frame].size];

        l = NSLocalizedStringFromTable(@"Download", @"QueryToolbar", @"Download button label");
        p = NSLocalizedStringFromTable(@"Download Selected Files", @"QueryToolbar", @"Download button palette label");

        item_download = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_download"];
            [item_download setLabel: l];
            [item_download setPaletteLabel: p];
            [item_download setAction: @selector(downloadSelected:)];
            [item_download setImage: [NSImage imageNamed: @"AcqDownload"]];

        l = NSLocalizedStringFromTable(@"Bitzi", @"QueryToolbar", @"Bitzi button label");
        p = NSLocalizedStringFromTable(@"Lookup Bitzi Ticket", @"QueryToolbar", @"Bitzi button palette label");
            
        item_bitzi = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_bitzi"];
            [item_bitzi setLabel: l];
            [item_bitzi setPaletteLabel: p];
            [item_bitzi setAction: @selector(bitziInfo:)];
            [item_bitzi setImage: [NSImage imageNamed: @"info"]];
    }


/* Events */

    - (void) selectionIsChanging: (id) theTableView; 
    {
        BOOL somethingIsSelected = [theTableView selectedRow] > -1;
        [item_download setTarget: (somethingIsSelected) ? self : nil];
        [item_bitzi setTarget: ([self selectedHasSha1]) ? self : nil];
        [super selectionIsChanging: theTableView];
    }


/* NSToolbar Delegate */

    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_search",
            @"item_filter",
            NSToolbarSeparatorItemIdentifier, 
            @"item_download",
            NSToolbarSeparatorItemIdentifier, 
            @"item_browsehost",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_download",
            @"item_bitzi",
            @"item_browsehost",
            @"item_filter",
            @"item_drawer",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }


/* Actions */

    - (BOOL) selectedHasSha1; 
    {
        id selected = [[[AqContentViewController instance] currentDelegate] selectedObjects];
        int i, count = [selected count];
        
        for (i=0; i<count; i++) {
            AqRemoteFile* theFile = [selected objectAtIndex: i];
            if ([theFile sha1])
                return YES;
        }
        return NO;
    }
    
    - (void) bitziInfo: (id) sender; 
    {
        id selected = [[[AqContentViewController instance] currentDelegate] selectedObjects];
        int i, count = [selected count];
        
        for (i=0; i<count; i++) 
        {
            AqRemoteFile* theFile = [selected objectAtIndex: i];
            id sha1 = [theFile sha1];
            
            /* chop off "urn:sha1" prefix */
            
                if ([sha1 hasPrefix: @"urn:sha1:"]) {
                    sha1 = [sha1 substringFromIndex: 9];
                }
                
            /* launch the browser */

                if (sha1) {
                    [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://bitzi.com/lookup/%@", sha1]]];
                }
        }
    }
    
@end