#import "AqNetworkController.h"
#import "AqNetworkToolbarDelegate.h"


@implementation AqNetworkToolbarDelegate

/* Initialization */

    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; {
        instance = self;
        [self initItems];
    }

    - (void) initItems; 
    {
        [self initSearch];
        [self initDrawer];
        [self initBrowseHost];

        id l,p;
        l = NSLocalizedStringFromTable(@"Remove", @"NetworkToolbar", @"Remove action label");
        p = NSLocalizedStringFromTable(@"Remove Connection", @"NetworkToolbar", @"Remove button palette label");

        item_cancel = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_cancel"];
            [item_cancel setLabel: l];
            [item_cancel setPaletteLabel: p];
            [item_cancel setAction: @selector(removeSelected:)];
            [item_cancel setImage: [NSImage imageNamed: @"delete"]];
    }

    - (id) toolbarIdentifier; {
        return @"AqNetworkToolbarDelegateB";
    }


/* Events */

    - (void) selectionIsChanging: (id) theTableView; {
        BOOL somethingIsSelected = [theTableView selectedRow] > -1;
        [item_cancel setTarget: (somethingIsSelected) ? self : nil];
        [super selectionIsChanging: theTableView];
    }
    

/* Actions */

    - (void) removeSelected: (id) sender; {
        [[AqNetworkController instance] removeSelected: nil];
    }


/* NSToolbar Delegate */

    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_search",
            NSToolbarSeparatorItemIdentifier, 
            @"item_cancel",
            NSToolbarSeparatorItemIdentifier, 
            @"item_browsehost",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_cancel",
            @"item_browsehost",
            @"item_drawer",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }

@end